<?php

namespace EnumType;

/**
 * This class stands for rsKundengruppeType EnumType
 * @subpackage Enumerations
 */
class RsKundengruppeType
{
    /**
     * Constant for value 'Familie/Paar'
     * @return string 'Familie/Paar'
     */
    const ENUM_VALUE_0 = 'Familie/Paar';
    /**
     * Constant for value 'Alleinerzieher/Single'
     * @return string 'Alleinerzieher/Single'
     */
    const ENUM_VALUE_1 = 'Alleinerzieher/Single';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
