<?php

namespace EnumType;

/**
 * This class stands for regionaldirektionType EnumType
 * @subpackage Enumerations
 */
class RegionaldirektionType
{
    /**
     * Constant for value 'Wien'
     * @return string 'Wien'
     */
    const ENUM_VALUE_0 = 'Wien';
    /**
     * Constant for value 'Niederösterreich'
     * @return string 'Niederösterreich'
     */
    const ENUM_VALUE_1 = 'Niederösterreich';
    /**
     * Constant for value 'Oberösterreich'
     * @return string 'Oberösterreich'
     */
    const ENUM_VALUE_2 = 'Oberösterreich';
    /**
     * Constant for value 'Salzburg'
     * @return string 'Salzburg'
     */
    const ENUM_VALUE_3 = 'Salzburg';
    /**
     * Constant for value 'Tirol'
     * @return string 'Tirol'
     */
    const ENUM_VALUE_4 = 'Tirol';
    /**
     * Constant for value 'Vorarlberg'
     * @return string 'Vorarlberg'
     */
    const ENUM_VALUE_5 = 'Vorarlberg';
    /**
     * Constant for value 'Burgenland'
     * @return string 'Burgenland'
     */
    const ENUM_VALUE_6 = 'Burgenland';
    /**
     * Constant for value 'Steiermark'
     * @return string 'Steiermark'
     */
    const ENUM_VALUE_7 = 'Steiermark';
    /**
     * Constant for value 'Kärnten/Osttirol'
     * @return string 'Kärnten/Osttirol'
     */
    const ENUM_VALUE_8 = 'Kärnten/Osttirol';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @uses self::ENUM_VALUE_5
     * @uses self::ENUM_VALUE_6
     * @uses self::ENUM_VALUE_7
     * @uses self::ENUM_VALUE_8
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
            self::ENUM_VALUE_5,
            self::ENUM_VALUE_6,
            self::ENUM_VALUE_7,
            self::ENUM_VALUE_8,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
