<?php

namespace EnumType;

/**
 * This class stands for rabattgrundType EnumType
 * @subpackage Enumerations
 */
class RabattgrundType
{
    /**
     * Constant for value 'außertariflicher Sonderrabatt'
     * @return string 'außertariflicher Sonderrabatt'
     */
    const ENUM_VALUE_0 = 'außertariflicher Sonderrabatt';
    /**
     * Constant for value 'Provisionsverzicht'
     * @return string 'Provisionsverzicht'
     */
    const ENUM_VALUE_1 = 'Provisionsverzicht';
    /**
     * Constant for value 'Fuhrparknachlass'
     * @return string 'Fuhrparknachlass'
     */
    const ENUM_VALUE_2 = 'Fuhrparknachlass';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
