<?php

namespace EnumType;

/**
 * This class stands for PasswordMessageType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Definiert alle möglichen Passwortfehler
 * @subpackage Enumerations
 */
class PasswordMessageType
{
    /**
     * Constant for value '1'
     * @return string '1'
     */
    const ENUM_VALUE_0 = '1';
    /**
     * Constant for value '2'
     * @return string '2'
     */
    const ENUM_VALUE_1 = '2';
    /**
     * Constant for value '3'
     * @return string '3'
     */
    const ENUM_VALUE_2 = '3';
    /**
     * Constant for value '4'
     * @return string '4'
     */
    const ENUM_VALUE_3 = '4';
    /**
     * Constant for value '5'
     * @return string '5'
     */
    const ENUM_VALUE_4 = '5';
    /**
     * Constant for value '6'
     * @return string '6'
     */
    const ENUM_VALUE_5 = '6';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @uses self::ENUM_VALUE_5
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
            self::ENUM_VALUE_5,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
