<?php

namespace EnumType;

/**
 * This class stands for kfzVerwendungType EnumType
 * @subpackage Enumerations
 */
class KfzVerwendungType
{
    /**
     * Constant for value 'ohne'
     * @return string 'ohne'
     */
    const ENUM_VALUE_0 = 'ohne';
    /**
     * Constant for value 'Abschleppwagen'
     * @return string 'Abschleppwagen'
     */
    const ENUM_VALUE_1 = 'Abschleppwagen';
    /**
     * Constant for value 'Feuerwehrwagen oder Bergrettungsdienst'
     * @return string 'Feuerwehrwagen oder Bergrettungsdienst'
     */
    const ENUM_VALUE_2 = 'Feuerwehrwagen oder Bergrettungsdienst';
    /**
     * Constant for value 'Rettungsdienst- und Krankenwagen'
     * @return string 'Rettungsdienst- und Krankenwagen'
     */
    const ENUM_VALUE_3 = 'Rettungsdienst- und Krankenwagen';
    /**
     * Constant for value 'Leichenwagen'
     * @return string 'Leichenwagen'
     */
    const ENUM_VALUE_4 = 'Leichenwagen';
    /**
     * Constant for value 'Straßendienst'
     * @return string 'Straßendienst'
     */
    const ENUM_VALUE_5 = 'Straßendienst';
    /**
     * Constant for value 'Schulfahrzeuge'
     * @return string 'Schulfahrzeuge'
     */
    const ENUM_VALUE_6 = 'Schulfahrzeuge';
    /**
     * Constant for value 'Mannschaftstransportwagen'
     * @return string 'Mannschaftstransportwagen'
     */
    const ENUM_VALUE_7 = 'Mannschaftstransportwagen';
    /**
     * Constant for value 'Müllabfuhr'
     * @return string 'Müllabfuhr'
     */
    const ENUM_VALUE_8 = 'Müllabfuhr';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @uses self::ENUM_VALUE_5
     * @uses self::ENUM_VALUE_6
     * @uses self::ENUM_VALUE_7
     * @uses self::ENUM_VALUE_8
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
            self::ENUM_VALUE_5,
            self::ENUM_VALUE_6,
            self::ENUM_VALUE_7,
            self::ENUM_VALUE_8,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
