<?php

namespace EnumType;

/**
 * This class stands for kfzVerwendung2Type EnumType
 * @subpackage Enumerations
 */
class KfzVerwendung2Type
{
    /**
     * Constant for value 'Reise'
     * @return string 'Reise'
     */
    const ENUM_VALUE_0 = 'Reise';
    /**
     * Constant for value 'Hotel-Gewerbe'
     * @return string 'Hotel-Gewerbe'
     */
    const ENUM_VALUE_1 = 'Hotel-Gewerbe';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
