<?php

namespace EnumType;

/**
 * This class stands for IVClaimBranch EnumType
 * Meta information extracted from the WSDL
 * - documentation: Claim for which the policy issue.
 * @subpackage Enumerations
 */
class IVClaimBranch
{
    /**
     * Constant for value 'KFZ'
     * @return string 'KFZ'
     */
    const ENUM_VALUE_0 = 'KFZ';
    /**
     * Constant for value 'KRANKEN'
     * @return string 'KRANKEN'
     */
    const ENUM_VALUE_1 = 'KRANKEN';
    /**
     * Constant for value 'RS'
     * @return string 'RS'
     */
    const ENUM_VALUE_2 = 'RS';
    /**
     * Constant for value 'SACHHAFT'
     * @return string 'SACHHAFT'
     */
    const ENUM_VALUE_3 = 'SACHHAFT';
    /**
     * Constant for value 'UNFALL'
     * @return string 'UNFALL'
     */
    const ENUM_VALUE_4 = 'UNFALL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
