<?php

namespace EnumType;

/**
 * This class stands for FondskategorieType EnumType
 * @subpackage Enumerations
 */
class FondskategorieType
{
    /**
     * Constant for value 'geringesRisiko'
     * @return string 'geringesRisiko'
     */
    const ENUM_VALUE_0 = 'geringesRisiko';
    /**
     * Constant for value 'mittleresRisiko'
     * @return string 'mittleresRisiko'
     */
    const ENUM_VALUE_1 = 'mittleresRisiko';
    /**
     * Constant for value 'hohesRisiko'
     * @return string 'hohesRisiko'
     */
    const ENUM_VALUE_2 = 'hohesRisiko';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
