<?php

namespace EnumType;

/**
 * This class stands for Fondskategorie EnumType
 * @subpackage Enumerations
 */
class Fondskategorie
{
    /**
     * Constant for value 'Garantiefondskonzept'
     * @return string 'Garantiefondskonzept'
     */
    const ENUM_VALUE_0 = 'Garantiefondskonzept';
    /**
     * Constant for value 'GeringesRisiko'
     * @return string 'GeringesRisiko'
     */
    const ENUM_VALUE_1 = 'GeringesRisiko';
    /**
     * Constant for value 'MittleresRisiko'
     * @return string 'MittleresRisiko'
     */
    const ENUM_VALUE_2 = 'MittleresRisiko';
    /**
     * Constant for value 'HohesRisiko'
     * @return string 'HohesRisiko'
     */
    const ENUM_VALUE_3 = 'HohesRisiko';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
