<?php

namespace EnumType;

/**
 * This class stands for ClaimentAnrede EnumType
 * @subpackage Enumerations
 */
class ClaimentAnrede
{
    /**
     * Constant for value '1'
     * Meta information extracted from the WSDL
     * - id: ClaimentAnredeHerr
     * @return string '1'
     */
    const ENUM_VALUE_0 = '1';
    /**
     * Constant for value '2'
     * Meta information extracted from the WSDL
     * - id: ClaimentAnredeFrau
     * @return string '2'
     */
    const ENUM_VALUE_1 = '2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
