<?php

namespace EnumType;

/**
 * This class stands for anredeType EnumType
 * @subpackage Enumerations
 */
class AnredeType
{
    /**
     * Constant for value 'Herr'
     * @return string 'Herr'
     */
    const ENUM_VALUE_0 = 'Herr';
    /**
     * Constant for value 'Frau'
     * @return string 'Frau'
     */
    const ENUM_VALUE_1 = 'Frau';
    /**
     * Constant for value 'Firma'
     * @return string 'Firma'
     */
    const ENUM_VALUE_2 = 'Firma';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
