<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://evpplus-int.generali.at/iss/connect?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://evpplus-int.generali.at/iss/connect?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Service ServiceType
 */
$service = new \ServiceType\Service($options);
/**
 * Sample call for getVersion operation/method
 */
if ($service->getVersion() !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for sendCustomer operation/method
 */
if ($service->sendCustomer(new \StructType\SendCustomerRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for createPartnerGroup operation/method
 */
if ($service->createPartnerGroup(new \StructType\CreatePartnerGroupRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getCustomer operation/method
 */
if ($service->getCustomer(new \StructType\GetCustomerRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for removeCustomer operation/method
 */
if ($service->removeCustomer(new \StructType\RemoveCustomerRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCase operation/method
 */
if ($service->newBusinessCase(new \StructType\NewBusinessCaseRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCaseIVOnline operation/method
 */
if ($service->newBusinessCaseIVOnline(new \StructType\NewBusinessCaseIVOnlineRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getBusinessCases operation/method
 */
if ($service->getBusinessCases(new \StructType\GetBusinessCasesRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getBusinessCase operation/method
 */
if ($service->getBusinessCase(new \StructType\GetBusinessCaseRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getIDFromNumbergenerator operation/method
 */
if ($service->getIDFromNumbergenerator(new \StructType\GetLatestIDFromNumbergeneratorRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCaseSMOnline operation/method
 */
if ($service->newBusinessCaseSMOnline(new \StructType\NewBusinessCaseSMOnlineRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getBusinessCaseTypes operation/method
 */
if ($service->getBusinessCaseTypes(new \StructType\GetBusinessCaseTypesRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getZeusdaten operation/method
 */
if ($service->getZeusdaten(new \StructType\GetZeusDatenRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for hasZeusdaten operation/method
 */
if ($service->hasZeusdaten(new \StructType\HasZeusDatenRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getZeusdatenGreco operation/method
 */
if ($service->getZeusdatenGreco(new \StructType\GetZeusDatenGrecoRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getVinkulierungsdaten operation/method
 */
if ($service->getVinkulierungsdaten(new \StructType\GetVinkulierungsdatenRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for sendMessageToMQ operation/method
 */
if ($service->sendMessageToMQ(new \StructType\SendMessageToMQRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for transferSignedDocument operation/method
 */
if ($service->transferSignedDocument(new \StructType\TransferSignedDocumentRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCasePrefilled operation/method
 */
if ($service->newBusinessCasePrefilled(new \StructType\NewBusinessCasePrefilledRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getBusinessCaseHistory operation/method
 */
if ($service->getBusinessCaseHistory(new \StructType\GetBusinessCaseHistoryRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for browseMessageFromMQ operation/method
 */
if ($service->browseMessageFromMQ(new \StructType\BrowseMessageFromMQRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCaseCalculateAndSave operation/method
 */
if ($service->newBusinessCaseCalculateAndSave(new \StructType\NewBusinessCaseCalculateAndSaveRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for calculatePremiumOnly operation/method
 */
if ($service->calculatePremiumOnly(new \StructType\CalculatePremiumOnlyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getChoiceLists operation/method
 */
if ($service->getChoiceLists(new \StructType\GetChoiceListsRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCaseToPolicy operation/method
 */
if ($service->newBusinessCaseToPolicy(new \StructType\NewBusinessCaseToPolicyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for addCustomerToBusinessCase operation/method
 */
if ($service->addCustomerToBusinessCase(new \StructType\AddCustomerToBusinessCaseRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getSignableDocuments operation/method
 */
if ($service->getSignableDocuments(new \StructType\GetSignableDocumentsRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for signDocuments operation/method
 */
if ($service->signDocuments(new \StructType\SignDocumentsRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getAreDocumentsSigned operation/method
 */
if ($service->getAreDocumentsSigned(new \StructType\GetAreDocumentsSignedRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for resetSignDocuments operation/method
 */
if ($service->resetSignDocuments(new \StructType\ResetSignDocumentsRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getSignedDocuments operation/method
 */
if ($service->getSignedDocuments(new \StructType\GetSignedDocumentsRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for createOrUpdatePartnerContact operation/method
 */
if ($service->createOrUpdatePartnerContact(new \StructType\CreateOrUpdatePartnerContactRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for orderGreenOrServiceCard operation/method
 */
if ($service->orderGreenOrServiceCard(new \StructType\OrderGreenOrServiceCardRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getHoraZone operation/method
 */
if ($service->getHoraZone(new \StructType\GetHoraZoneRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getBusinessCollectionData operation/method
 */
if ($service->getBusinessCollectionData(new \StructType\GetBusinessCollectionDataRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getBusinessCaseReadonlyLink operation/method
 */
if ($service->getBusinessCaseReadonlyLink(new \StructType\GetBusinessCaseReadonlyLinkRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for login operation/method
 */
if ($service->login(new \StructType\LoginRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalClaimAdviceInitial operation/method
 */
if ($service->kundenportalClaimAdviceInitial(new \StructType\KundenportalClaimAdviceInitialRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalClaimAdvice operation/method
 */
if ($service->kundenportalClaimAdvice(new \StructType\KundenportalClaimAdviceRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalVerzeichnisse operation/method
 */
if ($service->kundenportalVerzeichnisse(new \StructType\KundenportalVerzeichnisseRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalSchliessfach operation/method
 */
if ($service->kundenportalSchliessfach(new \StructType\KundenportalSchliessfachRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalAddUpdateOrDeleteSchliessfachEintrag
 * operation/method
 */
if ($service->kundenportalAddUpdateOrDeleteSchliessfachEintrag(new \StructType\KundenportalAddUpdateOrDeleteSchliessfachEintragRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalCreateDeleteSaveOrUpdateDocument operation/method
 */
if ($service->kundenportalCreateDeleteSaveOrUpdateDocument(new \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalGetDocument operation/method
 */
if ($service->kundenportalGetDocument(new \StructType\KundenportalGetDocumentRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalData operation/method
 */
if ($service->kundenportalData(new \StructType\KundenportalDataRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalRegister operation/method
 */
if ($service->kundenportalRegister(new \StructType\KundenportalRegisterRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalResendActivationLink operation/method
 */
if ($service->kundenportalResendActivationLink(new \StructType\KundenportalResendActivationLinkRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalActivation operation/method
 */
if ($service->kundenportalActivation(new \StructType\KundenportalActivationRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalNewsletterEmails operation/method
 */
if ($service->kundenportalNewsletterEmails(new \StructType\KundenportalNewsletterEmailsRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalPushNachricht operation/method
 */
if ($service->kundenportalPushNachricht(new \StructType\KundenportalPushNachrichtRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for mapCustomerToPAPartner operation/method
 */
if ($service->mapCustomerToPAPartner(new \StructType\MapCustomerToPAPartnerRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getArcImage operation/method
 */
if ($service->getArcImage(new \StructType\GetArcImageRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getArcImageInfos operation/method
 */
if ($service->getArcImageInfos(new \StructType\GetArcImageInfosRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for searchContract operation/method
 */
if ($service->searchContract(new \StructType\SearchContractRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for searchContractList operation/method
 */
if ($service->searchContractList(new \StructType\SearchContractListRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for itChat operation/method
 */
if ($service->itChat(new \StructType\ItChatRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getContract operation/method
 */
if ($service->getContract(new \StructType\GetContractRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getBerechnungswerte operation/method
 */
if ($service->getBerechnungswerte(new \StructType\GetBerechnungswerteRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getContracts operation/method
 */
if ($service->getContracts(new \StructType\GetContractsRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for addStateHistoryEntry operation/method
 */
if ($service->addStateHistoryEntry(new \StructType\AddStateHistoryEntryRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for transferBusinessCase operation/method
 */
if ($service->transferBusinessCase(new \StructType\TransferBusinessCaseRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCaseFromXml operation/method
 */
if ($service->newBusinessCaseFromXml(new \StructType\NewBusinessCaseFromXmlRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for searchClaim operation/method
 */
if ($service->searchClaim(new \StructType\SearchClaimRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for transferBusinessCases operation/method
 */
if ($service->transferBusinessCases(new \StructType\TransferBusinessCasesRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCaseSMOnlineTransfer operation/method
 */
if ($service->newBusinessCaseSMOnlineTransfer(new \StructType\NewBusinessCaseSMOnlineTransferRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCaseStorno operation/method
 */
if ($service->newBusinessCaseStorno(new \StructType\NewBusinessCaseStornoRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCaseInkassoAenderung operation/method
 */
if ($service->newBusinessCaseInkassoAenderung(new \StructType\NewBusinessCaseInkassoAenderungRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for newBusinessCaseVersicherungsBestaetigung operation/method
 */
if ($service->newBusinessCaseVersicherungsBestaetigung(new \StructType\NewBusinessCaseVersicherungsBestaetigungRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for searchClaimList operation/method
 */
if ($service->searchClaimList(new \StructType\SearchClaimListRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for registerUser operation/method
 */
if ($service->registerUser(new \StructType\RegisterUserRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for resetUserPassword operation/method
 */
if ($service->resetUserPassword(new \StructType\ResetUserPasswordRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for resetUserPasswordQuestionAnswer operation/method
 */
if ($service->resetUserPasswordQuestionAnswer(new \StructType\ResetUserPasswordQuestionAnswerRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getUserData operation/method
 */
if ($service->getUserData(new \StructType\GetUserDataRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for deleteUserDataTokens operation/method
 */
if ($service->deleteUserDataTokens(new \StructType\DeleteUserDataTokensRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for isValidSchadensnummerNachname operation/method
 */
if ($service->isValidSchadensnummerNachname(new \StructType\IsValidSchadensnummerNachnameRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalJwtInvalidateService operation/method
 */
if ($service->kundenportalJwtInvalidateService(new \StructType\KundenportalJwtInvalidateServiceRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalBenutzerPasswortAendern operation/method
 */
if ($service->kundenportalBenutzerPasswortAendern(new \StructType\KundenportalBenutzerPasswortAendernRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalBenutzernameAendern operation/method
 */
if ($service->kundenportalBenutzernameAendern(new \StructType\KundenportalBenutzernameAendernRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for resetUserNewsletter operation/method
 */
if ($service->resetUserNewsletter(new \StructType\ResetUserNewsletterRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalMarkMessageAsRead operation/method
 */
if ($service->kundenportalMarkMessageAsRead(new \StructType\KundenportalMarkMessageAsReadRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalAntragZustimmen operation/method
 */
if ($service->kundenportalAntragZustimmen(new \StructType\KundenportalAntragZustimmenRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalSendMessage operation/method
 */
if ($service->kundenportalSendMessage(new \StructType\KundenportalSendMessageRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for kundenportalSetAdvisor operation/method
 */
if ($service->kundenportalSetAdvisor(new \StructType\KundenportalSetAdvisorRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
