<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for versicherungsbestaetigungType StructType
 * @subpackage Structs
 */
class VersicherungsbestaetigungType extends AbstractStructBase
{
    /**
     * The vbArt
     * @var string
     */
    public $vbArt;
    /**
     * The vbAntragserbringer
     * Meta information extracted from the WSDL
     * - documentation: 7stellige Vermittlernummer (inkl. Sektion) des Antragserbringers - nur sichtbar, wenn vbArt != keine
     * - base: xs:string
     * - maxLength: 7
     * - minOccurs: 0
     * @var string
     */
    public $vbAntragserbringer;
    /**
     * Constructor method for versicherungsbestaetigungType
     * @uses VersicherungsbestaetigungType::setVbArt()
     * @uses VersicherungsbestaetigungType::setVbAntragserbringer()
     * @param string $vbArt
     * @param string $vbAntragserbringer
     */
    public function __construct($vbArt = null, $vbAntragserbringer = null)
    {
        $this
            ->setVbArt($vbArt)
            ->setVbAntragserbringer($vbAntragserbringer);
    }
    /**
     * Get vbArt value
     * @return string|null
     */
    public function getVbArt()
    {
        return $this->vbArt;
    }
    /**
     * Set vbArt value
     * @uses \EnumType\VbArtType::valueIsValid()
     * @uses \EnumType\VbArtType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vbArt
     * @return \StructType\VersicherungsbestaetigungType
     */
    public function setVbArt($vbArt = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VbArtType::valueIsValid($vbArt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VbArtType', is_array($vbArt) ? implode(', ', $vbArt) : var_export($vbArt, true), implode(', ', \EnumType\VbArtType::getValidValues())), __LINE__);
        }
        $this->vbArt = $vbArt;
        return $this;
    }
    /**
     * Get vbAntragserbringer value
     * @return string|null
     */
    public function getVbAntragserbringer()
    {
        return $this->vbAntragserbringer;
    }
    /**
     * Set vbAntragserbringer value
     * @param string $vbAntragserbringer
     * @return \StructType\VersicherungsbestaetigungType
     */
    public function setVbAntragserbringer($vbAntragserbringer = null)
    {
        // validation for constraint: string
        if (!is_null($vbAntragserbringer) && !is_string($vbAntragserbringer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vbAntragserbringer, true), gettype($vbAntragserbringer)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($vbAntragserbringer) && mb_strlen($vbAntragserbringer) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen($vbAntragserbringer)), __LINE__);
        }
        $this->vbAntragserbringer = $vbAntragserbringer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VersicherungsbestaetigungType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
