<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserType StructType
 * Meta information extracted from the WSDL
 * - documentation: Userdaten für einen Generali-eVP Benutzer
 * @subpackage Structs
 */
class UserType extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The geschlecht
     * @var string
     */
    public $geschlecht;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * @var string
     */
    public $name;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $vorname;
    /**
     * The telefon
     * Meta information extracted from the WSDL
     * - documentation: Die Telefonnummer muss einer der folgenden REGEX-Ausdrücke entsprechen, sonst wird die Nummer nicht übernommen: "[+]{1}[0-9]{2,4}[ ]{1}[0-9]{1,4}[ ]{1}([0-9]+|[0-9]+[ -][0-9]+)" oder "0[1-9]{1}[0-9]{0,3}[ ]{1}[0-9- ]*"
     * - base: String50
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $telefon;
    /**
     * The mail
     * Meta information extracted from the WSDL
     * - documentation: Eine gültige Mailadresse muss der angegebenen REGEX entsprechen"[A-Za-z0-9\\.\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/=\\?\\^\\_\\`\\{\\|\\}\\~]+@[A-Za-z0-9.-]+"
     * - base: String80
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $mail;
    /**
     * The adresse
     * @var \StructType\Adress
     */
    public $adresse;
    /**
     * Constructor method for UserType
     * @uses UserType::setLogin()
     * @uses UserType::setGeschlecht()
     * @uses UserType::setName()
     * @uses UserType::setVorname()
     * @uses UserType::setTelefon()
     * @uses UserType::setMail()
     * @uses UserType::setAdresse()
     * @param \StructType\Login $login
     * @param string $geschlecht
     * @param string $name
     * @param string $vorname
     * @param string $telefon
     * @param string $mail
     * @param \StructType\Adress $adresse
     */
    public function __construct(\StructType\Login $login = null, $geschlecht = null, $name = null, $vorname = null, $telefon = null, $mail = null, \StructType\Adress $adresse = null)
    {
        $this
            ->setLogin($login)
            ->setGeschlecht($geschlecht)
            ->setName($name)
            ->setVorname($vorname)
            ->setTelefon($telefon)
            ->setMail($mail)
            ->setAdresse($adresse);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\UserType
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get geschlecht value
     * @return string|null
     */
    public function getGeschlecht()
    {
        return $this->geschlecht;
    }
    /**
     * Set geschlecht value
     * @uses \EnumType\Salutation::valueIsValid()
     * @uses \EnumType\Salutation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geschlecht
     * @return \StructType\UserType
     */
    public function setGeschlecht($geschlecht = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Salutation::valueIsValid($geschlecht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Salutation', is_array($geschlecht) ? implode(', ', $geschlecht) : var_export($geschlecht, true), implode(', ', \EnumType\Salutation::getValidValues())), __LINE__);
        }
        $this->geschlecht = $geschlecht;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UserType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name) && mb_strlen($name) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\UserType
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($vorname) && mb_strlen($vorname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\UserType
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($telefon) && mb_strlen($telefon) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param string $mail
     * @return \StructType\UserType
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($mail) && mb_strlen($mail) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($mail)), __LINE__);
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get adresse value
     * @return \StructType\Adress|null
     */
    public function getAdresse()
    {
        return $this->adresse;
    }
    /**
     * Set adresse value
     * @param \StructType\Adress $adresse
     * @return \StructType\UserType
     */
    public function setAdresse(\StructType\Adress $adresse = null)
    {
        $this->adresse = $adresse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
