<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SocialInsurance StructType
 * Meta information extracted from the WSDL
 * - documentation: Daten zur Sozialversicherung
 * @subpackage Structs
 */
class SocialInsurance extends AbstractStructBase
{
    /**
     * The socialInsuranceNumber
     * Meta information extracted from the WSDL
     * - documentation: Sozialversicherungsnummer ohne Geburtsdatum
     * - base: xsd:string
     * - minLength: 4
     * - pattern: \d+
     * @var string
     */
    public $socialInsuranceNumber;
    /**
     * The socialInsuranceAuthority
     * @var string
     */
    public $socialInsuranceAuthority;
    /**
     * Constructor method for SocialInsurance
     * @uses SocialInsurance::setSocialInsuranceNumber()
     * @uses SocialInsurance::setSocialInsuranceAuthority()
     * @param string $socialInsuranceNumber
     * @param string $socialInsuranceAuthority
     */
    public function __construct($socialInsuranceNumber = null, $socialInsuranceAuthority = null)
    {
        $this
            ->setSocialInsuranceNumber($socialInsuranceNumber)
            ->setSocialInsuranceAuthority($socialInsuranceAuthority);
    }
    /**
     * Get socialInsuranceNumber value
     * @return string|null
     */
    public function getSocialInsuranceNumber()
    {
        return $this->socialInsuranceNumber;
    }
    /**
     * Set socialInsuranceNumber value
     * @param string $socialInsuranceNumber
     * @return \StructType\SocialInsurance
     */
    public function setSocialInsuranceNumber($socialInsuranceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($socialInsuranceNumber) && !is_string($socialInsuranceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialInsuranceNumber, true), gettype($socialInsuranceNumber)), __LINE__);
        }
        // validation for constraint: minLength(4)
        if (!is_null($socialInsuranceNumber) && mb_strlen($socialInsuranceNumber) < 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 4', mb_strlen($socialInsuranceNumber)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($socialInsuranceNumber) && !preg_match('/\\d+/', $socialInsuranceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($socialInsuranceNumber, true)), __LINE__);
        }
        $this->socialInsuranceNumber = $socialInsuranceNumber;
        return $this;
    }
    /**
     * Get socialInsuranceAuthority value
     * @return string|null
     */
    public function getSocialInsuranceAuthority()
    {
        return $this->socialInsuranceAuthority;
    }
    /**
     * Set socialInsuranceAuthority value
     * @uses \EnumType\SocialInsuranceAuthority::valueIsValid()
     * @uses \EnumType\SocialInsuranceAuthority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $socialInsuranceAuthority
     * @return \StructType\SocialInsurance
     */
    public function setSocialInsuranceAuthority($socialInsuranceAuthority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SocialInsuranceAuthority::valueIsValid($socialInsuranceAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SocialInsuranceAuthority', is_array($socialInsuranceAuthority) ? implode(', ', $socialInsuranceAuthority) : var_export($socialInsuranceAuthority, true), implode(', ', \EnumType\SocialInsuranceAuthority::getValidValues())), __LINE__);
        }
        $this->socialInsuranceAuthority = $socialInsuranceAuthority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SocialInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
