<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for risikoEigenheimType StructType
 * @subpackage Structs
 */
class RisikoEigenheimType extends AbstractStructBase
{
    /**
     * The baujahrGebaeude
     * @var int
     */
    public $baujahrGebaeude;
    /**
     * The verbauteFlaecheEG
     * @var int
     */
    public $verbauteFlaecheEG;
    /**
     * The verbauteFlaecheOG
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $verbauteFlaecheOG;
    /**
     * The verbauteFlaecheKeller
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $verbauteFlaecheKeller;
    /**
     * The verbauteFlaecheMansarde
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $verbauteFlaecheMansarde;
    /**
     * The nebengebaeude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nebengebaeude;
    /**
     * The verbauteFlaecheNebengebaeude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $verbauteFlaecheNebengebaeude;
    /**
     * The vorschaeden
     * @var string
     */
    public $vorschaeden;
    /**
     * The wenigerAls270TageBewohnt
     * Meta information extracted from the WSDL
     * - documentation: Die Gebäude sind nicht ständig bewohnt (weniger als 270 Tage pro Jahr)!
     * - minOccurs: 0
     * @var bool
     */
    public $wenigerAls270TageBewohnt;
    /**
     * Constructor method for risikoEigenheimType
     * @uses RisikoEigenheimType::setBaujahrGebaeude()
     * @uses RisikoEigenheimType::setVerbauteFlaecheEG()
     * @uses RisikoEigenheimType::setVerbauteFlaecheOG()
     * @uses RisikoEigenheimType::setVerbauteFlaecheKeller()
     * @uses RisikoEigenheimType::setVerbauteFlaecheMansarde()
     * @uses RisikoEigenheimType::setNebengebaeude()
     * @uses RisikoEigenheimType::setVerbauteFlaecheNebengebaeude()
     * @uses RisikoEigenheimType::setVorschaeden()
     * @uses RisikoEigenheimType::setWenigerAls270TageBewohnt()
     * @param int $baujahrGebaeude
     * @param int $verbauteFlaecheEG
     * @param int $verbauteFlaecheOG
     * @param int $verbauteFlaecheKeller
     * @param int $verbauteFlaecheMansarde
     * @param string $nebengebaeude
     * @param int $verbauteFlaecheNebengebaeude
     * @param string $vorschaeden
     * @param bool $wenigerAls270TageBewohnt
     */
    public function __construct($baujahrGebaeude = null, $verbauteFlaecheEG = null, $verbauteFlaecheOG = null, $verbauteFlaecheKeller = null, $verbauteFlaecheMansarde = null, $nebengebaeude = null, $verbauteFlaecheNebengebaeude = null, $vorschaeden = null, $wenigerAls270TageBewohnt = null)
    {
        $this
            ->setBaujahrGebaeude($baujahrGebaeude)
            ->setVerbauteFlaecheEG($verbauteFlaecheEG)
            ->setVerbauteFlaecheOG($verbauteFlaecheOG)
            ->setVerbauteFlaecheKeller($verbauteFlaecheKeller)
            ->setVerbauteFlaecheMansarde($verbauteFlaecheMansarde)
            ->setNebengebaeude($nebengebaeude)
            ->setVerbauteFlaecheNebengebaeude($verbauteFlaecheNebengebaeude)
            ->setVorschaeden($vorschaeden)
            ->setWenigerAls270TageBewohnt($wenigerAls270TageBewohnt);
    }
    /**
     * Get baujahrGebaeude value
     * @return int|null
     */
    public function getBaujahrGebaeude()
    {
        return $this->baujahrGebaeude;
    }
    /**
     * Set baujahrGebaeude value
     * @param int $baujahrGebaeude
     * @return \StructType\RisikoEigenheimType
     */
    public function setBaujahrGebaeude($baujahrGebaeude = null)
    {
        // validation for constraint: int
        if (!is_null($baujahrGebaeude) && !(is_int($baujahrGebaeude) || ctype_digit($baujahrGebaeude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baujahrGebaeude, true), gettype($baujahrGebaeude)), __LINE__);
        }
        $this->baujahrGebaeude = $baujahrGebaeude;
        return $this;
    }
    /**
     * Get verbauteFlaecheEG value
     * @return int|null
     */
    public function getVerbauteFlaecheEG()
    {
        return $this->verbauteFlaecheEG;
    }
    /**
     * Set verbauteFlaecheEG value
     * @param int $verbauteFlaecheEG
     * @return \StructType\RisikoEigenheimType
     */
    public function setVerbauteFlaecheEG($verbauteFlaecheEG = null)
    {
        // validation for constraint: int
        if (!is_null($verbauteFlaecheEG) && !(is_int($verbauteFlaecheEG) || ctype_digit($verbauteFlaecheEG))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verbauteFlaecheEG, true), gettype($verbauteFlaecheEG)), __LINE__);
        }
        $this->verbauteFlaecheEG = $verbauteFlaecheEG;
        return $this;
    }
    /**
     * Get verbauteFlaecheOG value
     * @return int|null
     */
    public function getVerbauteFlaecheOG()
    {
        return $this->verbauteFlaecheOG;
    }
    /**
     * Set verbauteFlaecheOG value
     * @param int $verbauteFlaecheOG
     * @return \StructType\RisikoEigenheimType
     */
    public function setVerbauteFlaecheOG($verbauteFlaecheOG = null)
    {
        // validation for constraint: int
        if (!is_null($verbauteFlaecheOG) && !(is_int($verbauteFlaecheOG) || ctype_digit($verbauteFlaecheOG))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verbauteFlaecheOG, true), gettype($verbauteFlaecheOG)), __LINE__);
        }
        $this->verbauteFlaecheOG = $verbauteFlaecheOG;
        return $this;
    }
    /**
     * Get verbauteFlaecheKeller value
     * @return int|null
     */
    public function getVerbauteFlaecheKeller()
    {
        return $this->verbauteFlaecheKeller;
    }
    /**
     * Set verbauteFlaecheKeller value
     * @param int $verbauteFlaecheKeller
     * @return \StructType\RisikoEigenheimType
     */
    public function setVerbauteFlaecheKeller($verbauteFlaecheKeller = null)
    {
        // validation for constraint: int
        if (!is_null($verbauteFlaecheKeller) && !(is_int($verbauteFlaecheKeller) || ctype_digit($verbauteFlaecheKeller))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verbauteFlaecheKeller, true), gettype($verbauteFlaecheKeller)), __LINE__);
        }
        $this->verbauteFlaecheKeller = $verbauteFlaecheKeller;
        return $this;
    }
    /**
     * Get verbauteFlaecheMansarde value
     * @return int|null
     */
    public function getVerbauteFlaecheMansarde()
    {
        return $this->verbauteFlaecheMansarde;
    }
    /**
     * Set verbauteFlaecheMansarde value
     * @param int $verbauteFlaecheMansarde
     * @return \StructType\RisikoEigenheimType
     */
    public function setVerbauteFlaecheMansarde($verbauteFlaecheMansarde = null)
    {
        // validation for constraint: int
        if (!is_null($verbauteFlaecheMansarde) && !(is_int($verbauteFlaecheMansarde) || ctype_digit($verbauteFlaecheMansarde))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verbauteFlaecheMansarde, true), gettype($verbauteFlaecheMansarde)), __LINE__);
        }
        $this->verbauteFlaecheMansarde = $verbauteFlaecheMansarde;
        return $this;
    }
    /**
     * Get nebengebaeude value
     * @return string|null
     */
    public function getNebengebaeude()
    {
        return $this->nebengebaeude;
    }
    /**
     * Set nebengebaeude value
     * @uses \EnumType\NebengebaeudeType::valueIsValid()
     * @uses \EnumType\NebengebaeudeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nebengebaeude
     * @return \StructType\RisikoEigenheimType
     */
    public function setNebengebaeude($nebengebaeude = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NebengebaeudeType::valueIsValid($nebengebaeude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NebengebaeudeType', is_array($nebengebaeude) ? implode(', ', $nebengebaeude) : var_export($nebengebaeude, true), implode(', ', \EnumType\NebengebaeudeType::getValidValues())), __LINE__);
        }
        $this->nebengebaeude = $nebengebaeude;
        return $this;
    }
    /**
     * Get verbauteFlaecheNebengebaeude value
     * @return int|null
     */
    public function getVerbauteFlaecheNebengebaeude()
    {
        return $this->verbauteFlaecheNebengebaeude;
    }
    /**
     * Set verbauteFlaecheNebengebaeude value
     * @param int $verbauteFlaecheNebengebaeude
     * @return \StructType\RisikoEigenheimType
     */
    public function setVerbauteFlaecheNebengebaeude($verbauteFlaecheNebengebaeude = null)
    {
        // validation for constraint: int
        if (!is_null($verbauteFlaecheNebengebaeude) && !(is_int($verbauteFlaecheNebengebaeude) || ctype_digit($verbauteFlaecheNebengebaeude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verbauteFlaecheNebengebaeude, true), gettype($verbauteFlaecheNebengebaeude)), __LINE__);
        }
        $this->verbauteFlaecheNebengebaeude = $verbauteFlaecheNebengebaeude;
        return $this;
    }
    /**
     * Get vorschaeden value
     * @return string|null
     */
    public function getVorschaeden()
    {
        return $this->vorschaeden;
    }
    /**
     * Set vorschaeden value
     * @uses \EnumType\RisikoVorschaedenType::valueIsValid()
     * @uses \EnumType\RisikoVorschaedenType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vorschaeden
     * @return \StructType\RisikoEigenheimType
     */
    public function setVorschaeden($vorschaeden = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RisikoVorschaedenType::valueIsValid($vorschaeden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RisikoVorschaedenType', is_array($vorschaeden) ? implode(', ', $vorschaeden) : var_export($vorschaeden, true), implode(', ', \EnumType\RisikoVorschaedenType::getValidValues())), __LINE__);
        }
        $this->vorschaeden = $vorschaeden;
        return $this;
    }
    /**
     * Get wenigerAls270TageBewohnt value
     * @return bool|null
     */
    public function getWenigerAls270TageBewohnt()
    {
        return $this->wenigerAls270TageBewohnt;
    }
    /**
     * Set wenigerAls270TageBewohnt value
     * @param bool $wenigerAls270TageBewohnt
     * @return \StructType\RisikoEigenheimType
     */
    public function setWenigerAls270TageBewohnt($wenigerAls270TageBewohnt = null)
    {
        // validation for constraint: boolean
        if (!is_null($wenigerAls270TageBewohnt) && !is_bool($wenigerAls270TageBewohnt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wenigerAls270TageBewohnt, true), gettype($wenigerAls270TageBewohnt)), __LINE__);
        }
        $this->wenigerAls270TageBewohnt = $wenigerAls270TageBewohnt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RisikoEigenheimType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
