<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for registerUserResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Legt einen neuen Benutzer zur Registirerung an.
 * @subpackage Structs
 */
class RegisterUserResponse extends AbstractStructBase
{
    /**
     * The partyFiposId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $partyFiposId;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyNumber;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for registerUserResponse
     * @uses RegisterUserResponse::setPartyFiposId()
     * @uses RegisterUserResponse::setPolicyNumber()
     * @uses RegisterUserResponse::setEvpServiceFault()
     * @param int $partyFiposId
     * @param string $policyNumber
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct($partyFiposId = null, $policyNumber = null, \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setPartyFiposId($partyFiposId)
            ->setPolicyNumber($policyNumber)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get partyFiposId value
     * @return int|null
     */
    public function getPartyFiposId()
    {
        return $this->partyFiposId;
    }
    /**
     * Set partyFiposId value
     * @param int $partyFiposId
     * @return \StructType\RegisterUserResponse
     */
    public function setPartyFiposId($partyFiposId = null)
    {
        // validation for constraint: int
        if (!is_null($partyFiposId) && !(is_int($partyFiposId) || ctype_digit($partyFiposId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partyFiposId, true), gettype($partyFiposId)), __LINE__);
        }
        $this->partyFiposId = $partyFiposId;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\RegisterUserResponse
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\RegisterUserResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegisterUserResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
