<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for registerUserRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zum Anlegen eines Benutzers
 * @subpackage Structs
 */
class RegisterUserRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The emailBestaetigung
     * @var string
     */
    public $emailBestaetigung;
    /**
     * The vorname
     * @var string
     */
    public $vorname;
    /**
     * The nachname
     * @var string
     */
    public $nachname;
    /**
     * The geburtsdatum
     * @var string
     */
    public $geburtsdatum;
    /**
     * The polizzennummer
     * @var string
     */
    public $polizzennummer;
    /**
     * The elektrkomm
     * @var bool
     */
    public $elektrkomm;
    /**
     * The pwd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pwd;
    /**
     * Constructor method for registerUserRequest
     * @uses RegisterUserRequest::setLogin()
     * @uses RegisterUserRequest::setEmail()
     * @uses RegisterUserRequest::setEmailBestaetigung()
     * @uses RegisterUserRequest::setVorname()
     * @uses RegisterUserRequest::setNachname()
     * @uses RegisterUserRequest::setGeburtsdatum()
     * @uses RegisterUserRequest::setPolizzennummer()
     * @uses RegisterUserRequest::setElektrkomm()
     * @uses RegisterUserRequest::setPwd()
     * @param \StructType\Login $login
     * @param string $email
     * @param string $emailBestaetigung
     * @param string $vorname
     * @param string $nachname
     * @param string $geburtsdatum
     * @param string $polizzennummer
     * @param bool $elektrkomm
     * @param string $pwd
     */
    public function __construct(\StructType\Login $login = null, $email = null, $emailBestaetigung = null, $vorname = null, $nachname = null, $geburtsdatum = null, $polizzennummer = null, $elektrkomm = null, $pwd = null)
    {
        $this
            ->setLogin($login)
            ->setEmail($email)
            ->setEmailBestaetigung($emailBestaetigung)
            ->setVorname($vorname)
            ->setNachname($nachname)
            ->setGeburtsdatum($geburtsdatum)
            ->setPolizzennummer($polizzennummer)
            ->setElektrkomm($elektrkomm)
            ->setPwd($pwd);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\RegisterUserRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\RegisterUserRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get emailBestaetigung value
     * @return string|null
     */
    public function getEmailBestaetigung()
    {
        return $this->emailBestaetigung;
    }
    /**
     * Set emailBestaetigung value
     * @param string $emailBestaetigung
     * @return \StructType\RegisterUserRequest
     */
    public function setEmailBestaetigung($emailBestaetigung = null)
    {
        // validation for constraint: string
        if (!is_null($emailBestaetigung) && !is_string($emailBestaetigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBestaetigung, true), gettype($emailBestaetigung)), __LINE__);
        }
        $this->emailBestaetigung = $emailBestaetigung;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\RegisterUserRequest
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\RegisterUserRequest
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get geburtsdatum value
     * @return string|null
     */
    public function getGeburtsdatum()
    {
        return $this->geburtsdatum;
    }
    /**
     * Set geburtsdatum value
     * @param string $geburtsdatum
     * @return \StructType\RegisterUserRequest
     */
    public function setGeburtsdatum($geburtsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatum) && !is_string($geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatum, true), gettype($geburtsdatum)), __LINE__);
        }
        $this->geburtsdatum = $geburtsdatum;
        return $this;
    }
    /**
     * Get polizzennummer value
     * @return string|null
     */
    public function getPolizzennummer()
    {
        return $this->polizzennummer;
    }
    /**
     * Set polizzennummer value
     * @param string $polizzennummer
     * @return \StructType\RegisterUserRequest
     */
    public function setPolizzennummer($polizzennummer = null)
    {
        // validation for constraint: string
        if (!is_null($polizzennummer) && !is_string($polizzennummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($polizzennummer, true), gettype($polizzennummer)), __LINE__);
        }
        $this->polizzennummer = $polizzennummer;
        return $this;
    }
    /**
     * Get elektrkomm value
     * @return bool|null
     */
    public function getElektrkomm()
    {
        return $this->elektrkomm;
    }
    /**
     * Set elektrkomm value
     * @param bool $elektrkomm
     * @return \StructType\RegisterUserRequest
     */
    public function setElektrkomm($elektrkomm = null)
    {
        // validation for constraint: boolean
        if (!is_null($elektrkomm) && !is_bool($elektrkomm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($elektrkomm, true), gettype($elektrkomm)), __LINE__);
        }
        $this->elektrkomm = $elektrkomm;
        return $this;
    }
    /**
     * Get pwd value
     * @return string|null
     */
    public function getPwd()
    {
        return $this->pwd;
    }
    /**
     * Set pwd value
     * @param string $pwd
     * @return \StructType\RegisterUserRequest
     */
    public function setPwd($pwd = null)
    {
        // validation for constraint: string
        if (!is_null($pwd) && !is_string($pwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwd, true), gettype($pwd)), __LINE__);
        }
        $this->pwd = $pwd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegisterUserRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
