<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recipient StructType
 * Meta information extracted from the WSDL
 * - documentation: Empfänger
 * @subpackage Structs
 */
class Recipient extends AbstractStructBase
{
    /**
     * The customerCommunication
     * Meta information extracted from the WSDL
     * - documentation: Telefonnummer, eMail-Adresse
     * @var \StructType\BankAccount
     */
    public $customerCommunication;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - documentation: Zahlungsbetrag
     * @var string
     */
    public $amount;
    /**
     * Constructor method for Recipient
     * @uses Recipient::setCustomerCommunication()
     * @uses Recipient::setAmount()
     * @param \StructType\BankAccount $customerCommunication
     * @param string $amount
     */
    public function __construct(\StructType\BankAccount $customerCommunication = null, $amount = null)
    {
        $this
            ->setCustomerCommunication($customerCommunication)
            ->setAmount($amount);
    }
    /**
     * Get customerCommunication value
     * @return \StructType\BankAccount|null
     */
    public function getCustomerCommunication()
    {
        return $this->customerCommunication;
    }
    /**
     * Set customerCommunication value
     * @param \StructType\BankAccount $customerCommunication
     * @return \StructType\Recipient
     */
    public function setCustomerCommunication(\StructType\BankAccount $customerCommunication = null)
    {
        $this->customerCommunication = $customerCommunication;
        return $this;
    }
    /**
     * Get amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\Recipient
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Recipient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
