<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerRoles StructType
 * @subpackage Structs
 */
class PartnerRoles extends AbstractStructBase
{
    /**
     * The antragsteller
     * @var string
     */
    public $antragsteller;
    /**
     * The versicherungsnehmer
     * @var string
     */
    public $versicherungsnehmer;
    /**
     * The inkassoPartner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inkassoPartner;
    /**
     * The weitererVN
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $weitererVN;
    /**
     * Constructor method for PartnerRoles
     * @uses PartnerRoles::setAntragsteller()
     * @uses PartnerRoles::setVersicherungsnehmer()
     * @uses PartnerRoles::setInkassoPartner()
     * @uses PartnerRoles::setWeitererVN()
     * @param string $antragsteller
     * @param string $versicherungsnehmer
     * @param string $inkassoPartner
     * @param string[] $weitererVN
     */
    public function __construct($antragsteller = null, $versicherungsnehmer = null, $inkassoPartner = null, array $weitererVN = array())
    {
        $this
            ->setAntragsteller($antragsteller)
            ->setVersicherungsnehmer($versicherungsnehmer)
            ->setInkassoPartner($inkassoPartner)
            ->setWeitererVN($weitererVN);
    }
    /**
     * Get antragsteller value
     * @return string|null
     */
    public function getAntragsteller()
    {
        return $this->antragsteller;
    }
    /**
     * Set antragsteller value
     * @param string $antragsteller
     * @return \StructType\PartnerRoles
     */
    public function setAntragsteller($antragsteller = null)
    {
        // validation for constraint: string
        if (!is_null($antragsteller) && !is_string($antragsteller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antragsteller, true), gettype($antragsteller)), __LINE__);
        }
        $this->antragsteller = $antragsteller;
        return $this;
    }
    /**
     * Get versicherungsnehmer value
     * @return string|null
     */
    public function getVersicherungsnehmer()
    {
        return $this->versicherungsnehmer;
    }
    /**
     * Set versicherungsnehmer value
     * @param string $versicherungsnehmer
     * @return \StructType\PartnerRoles
     */
    public function setVersicherungsnehmer($versicherungsnehmer = null)
    {
        // validation for constraint: string
        if (!is_null($versicherungsnehmer) && !is_string($versicherungsnehmer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versicherungsnehmer, true), gettype($versicherungsnehmer)), __LINE__);
        }
        $this->versicherungsnehmer = $versicherungsnehmer;
        return $this;
    }
    /**
     * Get inkassoPartner value
     * @return string|null
     */
    public function getInkassoPartner()
    {
        return $this->inkassoPartner;
    }
    /**
     * Set inkassoPartner value
     * @param string $inkassoPartner
     * @return \StructType\PartnerRoles
     */
    public function setInkassoPartner($inkassoPartner = null)
    {
        // validation for constraint: string
        if (!is_null($inkassoPartner) && !is_string($inkassoPartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inkassoPartner, true), gettype($inkassoPartner)), __LINE__);
        }
        $this->inkassoPartner = $inkassoPartner;
        return $this;
    }
    /**
     * Get weitererVN value
     * @return string[]|null
     */
    public function getWeitererVN()
    {
        return $this->weitererVN;
    }
    /**
     * This method is responsible for validating the values passed to the setWeitererVN method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeitererVN method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeitererVNForArrayConstraintsFromSetWeitererVN(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partnerRolesWeitererVNItem) {
            // validation for constraint: itemType
            if (!is_string($partnerRolesWeitererVNItem)) {
                $invalidValues[] = is_object($partnerRolesWeitererVNItem) ? get_class($partnerRolesWeitererVNItem) : sprintf('%s(%s)', gettype($partnerRolesWeitererVNItem), var_export($partnerRolesWeitererVNItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weitererVN property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weitererVN value
     * @throws \InvalidArgumentException
     * @param string[] $weitererVN
     * @return \StructType\PartnerRoles
     */
    public function setWeitererVN(array $weitererVN = array())
    {
        // validation for constraint: array
        if ('' !== ($weitererVNArrayErrorMessage = self::validateWeitererVNForArrayConstraintsFromSetWeitererVN($weitererVN))) {
            throw new \InvalidArgumentException($weitererVNArrayErrorMessage, __LINE__);
        }
        $this->weitererVN = $weitererVN;
        return $this;
    }
    /**
     * Add item to weitererVN value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PartnerRoles
     */
    public function addToWeitererVN($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The weitererVN property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weitererVN[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartnerRoles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
