<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageHeader StructType
 * Meta information extracted from the WSDL
 * - documentation: Nachricht Kopfdaten
 * @subpackage Structs
 */
class MessageHeader extends AbstractStructBase
{
    /**
     * The messageOid
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Message ID für den internen Gebrauch
     * @var string
     */
    public $messageOid;
    /**
     * The unread
     * Meta information extracted from the WSDL
     * - documentation: Wurde die Message bereits gelesen?
     * @var bool
     */
    public $unread;
    /**
     * The header
     * Meta information extracted from the WSDL
     * - documentation: Betreff
     * @var string
     */
    public $header;
    /**
     * The senderName
     * Meta information extracted from the WSDL
     * - documentation: Betreff
     * @var string
     */
    public $senderName;
    /**
     * The senderYid
     * Meta information extracted from the WSDL
     * - documentation: Betreff
     * @var string
     */
    public $senderYid;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - documentation: Wann wurde die Message erzeugt
     * @var string
     */
    public $date;
    /**
     * The deleted
     * Meta information extracted from the WSDL
     * - documentation: Gibt an ob eine Nachricht gelöscht ist
     * @var bool
     */
    public $deleted;
    /**
     * The deletable
     * Meta information extracted from the WSDL
     * - documentation: Gibt an ob eine Nachricht gelöscht werden darf
     * @var bool
     */
    public $deletable;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: Gibt den fachlichen Text für den Nachrichtetyp an
     * @var string
     */
    public $type;
    /**
     * The messageType
     * Meta information extracted from the WSDL
     * - documentation: Gibt den Typ der Nachricht an
     * @var string
     */
    public $messageType;
    /**
     * Constructor method for MessageHeader
     * @uses MessageHeader::setMessageOid()
     * @uses MessageHeader::setUnread()
     * @uses MessageHeader::setHeader()
     * @uses MessageHeader::setSenderName()
     * @uses MessageHeader::setSenderYid()
     * @uses MessageHeader::setDate()
     * @uses MessageHeader::setDeleted()
     * @uses MessageHeader::setDeletable()
     * @uses MessageHeader::setType()
     * @uses MessageHeader::setMessageType()
     * @param string $messageOid
     * @param bool $unread
     * @param string $header
     * @param string $senderName
     * @param string $senderYid
     * @param string $date
     * @param bool $deleted
     * @param bool $deletable
     * @param string $type
     * @param string $messageType
     */
    public function __construct($messageOid = null, $unread = null, $header = null, $senderName = null, $senderYid = null, $date = null, $deleted = null, $deletable = null, $type = null, $messageType = null)
    {
        $this
            ->setMessageOid($messageOid)
            ->setUnread($unread)
            ->setHeader($header)
            ->setSenderName($senderName)
            ->setSenderYid($senderYid)
            ->setDate($date)
            ->setDeleted($deleted)
            ->setDeletable($deletable)
            ->setType($type)
            ->setMessageType($messageType);
    }
    /**
     * Get messageOid value
     * @return string|null
     */
    public function getMessageOid()
    {
        return $this->messageOid;
    }
    /**
     * Set messageOid value
     * @param string $messageOid
     * @return \StructType\MessageHeader
     */
    public function setMessageOid($messageOid = null)
    {
        // validation for constraint: string
        if (!is_null($messageOid) && !is_string($messageOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageOid, true), gettype($messageOid)), __LINE__);
        }
        $this->messageOid = $messageOid;
        return $this;
    }
    /**
     * Get unread value
     * @return bool|null
     */
    public function getUnread()
    {
        return $this->unread;
    }
    /**
     * Set unread value
     * @param bool $unread
     * @return \StructType\MessageHeader
     */
    public function setUnread($unread = null)
    {
        // validation for constraint: boolean
        if (!is_null($unread) && !is_bool($unread)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unread, true), gettype($unread)), __LINE__);
        }
        $this->unread = $unread;
        return $this;
    }
    /**
     * Get header value
     * @return string|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param string $header
     * @return \StructType\MessageHeader
     */
    public function setHeader($header = null)
    {
        // validation for constraint: string
        if (!is_null($header) && !is_string($header)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($header, true), gettype($header)), __LINE__);
        }
        $this->header = $header;
        return $this;
    }
    /**
     * Get senderName value
     * @return string|null
     */
    public function getSenderName()
    {
        return $this->senderName;
    }
    /**
     * Set senderName value
     * @param string $senderName
     * @return \StructType\MessageHeader
     */
    public function setSenderName($senderName = null)
    {
        // validation for constraint: string
        if (!is_null($senderName) && !is_string($senderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderName, true), gettype($senderName)), __LINE__);
        }
        $this->senderName = $senderName;
        return $this;
    }
    /**
     * Get senderYid value
     * @return string|null
     */
    public function getSenderYid()
    {
        return $this->senderYid;
    }
    /**
     * Set senderYid value
     * @param string $senderYid
     * @return \StructType\MessageHeader
     */
    public function setSenderYid($senderYid = null)
    {
        // validation for constraint: string
        if (!is_null($senderYid) && !is_string($senderYid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderYid, true), gettype($senderYid)), __LINE__);
        }
        $this->senderYid = $senderYid;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\MessageHeader
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get deleted value
     * @return bool|null
     */
    public function getDeleted()
    {
        return $this->deleted;
    }
    /**
     * Set deleted value
     * @param bool $deleted
     * @return \StructType\MessageHeader
     */
    public function setDeleted($deleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleted) && !is_bool($deleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deleted, true), gettype($deleted)), __LINE__);
        }
        $this->deleted = $deleted;
        return $this;
    }
    /**
     * Get deletable value
     * @return bool|null
     */
    public function getDeletable()
    {
        return $this->deletable;
    }
    /**
     * Set deletable value
     * @param bool $deletable
     * @return \StructType\MessageHeader
     */
    public function setDeletable($deletable = null)
    {
        // validation for constraint: boolean
        if (!is_null($deletable) && !is_bool($deletable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deletable, true), gettype($deletable)), __LINE__);
        }
        $this->deletable = $deletable;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\MessageHeader
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @uses \EnumType\MessageType::valueIsValid()
     * @uses \EnumType\MessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageType
     * @return \StructType\MessageHeader
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageType::valueIsValid($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MessageType', is_array($messageType) ? implode(', ', $messageType) : var_export($messageType, true), implode(', ', \EnumType\MessageType::getValidValues())), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
