<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mapCustomerToPAPartnerResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Response zum Mappen eines WS-Customers --> PA Partner
 * @subpackage Structs
 */
class MapCustomerToPAPartnerResponse extends AbstractStructBase
{
    /**
     * The paPartner
     * Meta information extracted from the WSDL
     * - documentation: PA Partner als XML
     * - minOccurs: 0
     * @var string
     */
    public $paPartner;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for mapCustomerToPAPartnerResponse
     * @uses MapCustomerToPAPartnerResponse::setPaPartner()
     * @uses MapCustomerToPAPartnerResponse::setEvpServiceFault()
     * @param string $paPartner
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct($paPartner = null, \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setPaPartner($paPartner)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get paPartner value
     * @return string|null
     */
    public function getPaPartner()
    {
        return $this->paPartner;
    }
    /**
     * Set paPartner value
     * @param string $paPartner
     * @return \StructType\MapCustomerToPAPartnerResponse
     */
    public function setPaPartner($paPartner = null)
    {
        // validation for constraint: string
        if (!is_null($paPartner) && !is_string($paPartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paPartner, true), gettype($paPartner)), __LINE__);
        }
        $this->paPartner = $paPartner;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\MapCustomerToPAPartnerResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MapCustomerToPAPartnerResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
