<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalDataResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal Data Response
 * @subpackage Structs
 */
class KundenportalDataResponse extends AbstractStructBase
{
    /**
     * The advisor
     * Meta information extracted from the WSDL
     * - documentation: Betreuer
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Advisor
     */
    public $advisor;
    /**
     * The possibleAdvisor
     * Meta information extracted from the WSDL
     * - documentation: Betreuer
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Advisor[]
     */
    public $possibleAdvisor;
    /**
     * The contractResult
     * Meta information extracted from the WSDL
     * - documentation: 0...n Verträge
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $contractResult;
    /**
     * The meineVerträgeRundUmBesitz
     * Meta information extracted from the WSDL
     * - documentation: 0...n meine Verträge rund um Besitz
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $meineVerträgeRundUmBesitz;
    /**
     * The weitereVerträgeImBereichBesitz
     * Meta information extracted from the WSDL
     * - documentation: 0...n weitere Verträge im Bereich Besitz
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $weitereVerträgeImBereichBesitz;
    /**
     * The meineVerträgeRundUmsBusiness
     * Meta information extracted from the WSDL
     * - documentation: 0...n meine Verträge im Bereich Business
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $meineVerträgeRundUmsBusiness;
    /**
     * The weitereVerträgeImBereichBusiness
     * Meta information extracted from the WSDL
     * - documentation: 0...n weitere Verträge im Bereich Business
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $weitereVerträgeImBereichBusiness;
    /**
     * The aktiveVerträgeForTypeVNVP_Betrieb
     * Meta information extracted from the WSDL
     * - documentation: 0...n aktive Verträge im Bereich Gesundheit VN VP
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $aktiveVerträgeForTypeVNVP_Betrieb;
    /**
     * The aktiveVerträgeForTypeVNVPWVN_Privat
     * Meta information extracted from the WSDL
     * - documentation: 0...n aktive Verträge im Bereich Gesundheit VN VP WVN Privat
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $aktiveVerträgeForTypeVNVPWVN_Privat;
    /**
     * The weitereVerträgeImBereichGesundheit
     * Meta information extracted from the WSDL
     * - documentation: 0...n weitere Verträge im Bereich Gesundheit
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $weitereVerträgeImBereichGesundheit;
    /**
     * The meineKFZVerträge
     * Meta information extracted from the WSDL
     * - documentation: 0...n meine Verträge im Bereich KFZ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $meineKFZVerträge;
    /**
     * The weitereVerträgeImBereichKFZ
     * Meta information extracted from the WSDL
     * - documentation: 0...n weitere Verträge im Bereich KFZ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $weitereVerträgeImBereichKFZ;
    /**
     * The meineVerträgeAusDerPrivatenLebensvorsorge
     * Meta information extracted from the WSDL
     * - documentation: 0...n meine Verträge im Bereich Leben
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $meineVerträgeAusDerPrivatenLebensvorsorge;
    /**
     * The meineVerträgeAusDerBetrieblichenAltersvorsorge
     * Meta information extracted from the WSDL
     * - documentation: 0...n meine Verträge im Bereich Leben/Betriebliche
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $meineVerträgeAusDerBetrieblichenAltersvorsorge;
    /**
     * The weitereVerträgeImBereichLebensvorsorge
     * Meta information extracted from the WSDL
     * - documentation: 0...n weitere Verträge im Bereich Leben
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $weitereVerträgeImBereichLebensvorsorge;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - documentation: Benutzerdaten
     * - minOccurs: 0
     * @var \StructType\User
     */
    public $user;
    /**
     * The startpageLink
     * Meta information extracted from the WSDL
     * - documentation: http-Link for kundenportalncluding the sessionID
     * - minOccurs: 0
     * @var string
     */
    public $startpageLink;
    /**
     * The messageHeaders
     * Meta information extracted from the WSDL
     * - documentation: alle empfangenen Nachrichten - Kopfinformationen
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MessageHeader[]
     */
    public $messageHeaders;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - documentation: Kundendaten
     * - minOccurs: 0
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The outstandingPayment
     * Meta information extracted from the WSDL
     * - documentation: Offene Zahlungen
     * - minOccurs: 0
     * @var bool
     */
    public $outstandingPayment;
    /**
     * The claim
     * Meta information extracted from the WSDL
     * - documentation: 0...n Schäden
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Claim[]
     */
    public $claim;
    /**
     * The hasCustomerAccountPayment
     * Meta information extracted from the WSDL
     * - documentation: Mindestens ein Vertrag mit Kundenkonto vorhanden
     * - minOccurs: 0
     * @var bool
     */
    public $hasCustomerAccountPayment;
    /**
     * The activationNecessary
     * Meta information extracted from the WSDL
     * - documentation: Steuert ob der Benutzer zwingend auf die Aktivierung umgeleitet werden muss
     * - minOccurs: 0
     * @var bool
     */
    public $activationNecessary;
    /**
     * The eCom
     * Meta information extracted from the WSDL
     * - documentation: Steuert ob die elektronische Kommunikation möglich ist
     * - minOccurs: 0
     * @var bool
     */
    public $eCom;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - documentation: Optional Fehler
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for kundenportalDataResponse
     * @uses KundenportalDataResponse::setAdvisor()
     * @uses KundenportalDataResponse::setPossibleAdvisor()
     * @uses KundenportalDataResponse::setContractResult()
     * @uses KundenportalDataResponse::setMeineVerträgeRundUmBesitz()
     * @uses KundenportalDataResponse::setWeitereVerträgeImBereichBesitz()
     * @uses KundenportalDataResponse::setMeineVerträgeRundUmsBusiness()
     * @uses KundenportalDataResponse::setWeitereVerträgeImBereichBusiness()
     * @uses KundenportalDataResponse::setAktiveVerträgeForTypeVNVP_Betrieb()
     * @uses KundenportalDataResponse::setAktiveVerträgeForTypeVNVPWVN_Privat()
     * @uses KundenportalDataResponse::setWeitereVerträgeImBereichGesundheit()
     * @uses KundenportalDataResponse::setMeineKFZVerträge()
     * @uses KundenportalDataResponse::setWeitereVerträgeImBereichKFZ()
     * @uses KundenportalDataResponse::setMeineVerträgeAusDerPrivatenLebensvorsorge()
     * @uses KundenportalDataResponse::setMeineVerträgeAusDerBetrieblichenAltersvorsorge()
     * @uses KundenportalDataResponse::setWeitereVerträgeImBereichLebensvorsorge()
     * @uses KundenportalDataResponse::setUser()
     * @uses KundenportalDataResponse::setStartpageLink()
     * @uses KundenportalDataResponse::setMessageHeaders()
     * @uses KundenportalDataResponse::setCustomer()
     * @uses KundenportalDataResponse::setOutstandingPayment()
     * @uses KundenportalDataResponse::setClaim()
     * @uses KundenportalDataResponse::setHasCustomerAccountPayment()
     * @uses KundenportalDataResponse::setActivationNecessary()
     * @uses KundenportalDataResponse::setECom()
     * @uses KundenportalDataResponse::setEvpServiceFault()
     * @param \StructType\Advisor $advisor
     * @param \StructType\Advisor[] $possibleAdvisor
     * @param \StructType\ContractSearchDetail[] $contractResult
     * @param \StructType\ContractSearchDetail[] $meineVerträgeRundUmBesitz
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichBesitz
     * @param \StructType\ContractSearchDetail[] $meineVerträgeRundUmsBusiness
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichBusiness
     * @param \StructType\ContractSearchDetail[] $aktiveVerträgeForTypeVNVP_Betrieb
     * @param \StructType\ContractSearchDetail[] $aktiveVerträgeForTypeVNVPWVN_Privat
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichGesundheit
     * @param \StructType\ContractSearchDetail[] $meineKFZVerträge
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichKFZ
     * @param \StructType\ContractSearchDetail[] $meineVerträgeAusDerPrivatenLebensvorsorge
     * @param \StructType\ContractSearchDetail[] $meineVerträgeAusDerBetrieblichenAltersvorsorge
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichLebensvorsorge
     * @param \StructType\User $user
     * @param string $startpageLink
     * @param \StructType\MessageHeader[] $messageHeaders
     * @param \StructType\Customer $customer
     * @param bool $outstandingPayment
     * @param \StructType\Claim[] $claim
     * @param bool $hasCustomerAccountPayment
     * @param bool $activationNecessary
     * @param bool $eCom
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct(\StructType\Advisor $advisor = null, array $possibleAdvisor = array(), array $contractResult = array(), array $meineVerträgeRundUmBesitz = array(), array $weitereVerträgeImBereichBesitz = array(), array $meineVerträgeRundUmsBusiness = array(), array $weitereVerträgeImBereichBusiness = array(), array $aktiveVerträgeForTypeVNVP_Betrieb = array(), array $aktiveVerträgeForTypeVNVPWVN_Privat = array(), array $weitereVerträgeImBereichGesundheit = array(), array $meineKFZVerträge = array(), array $weitereVerträgeImBereichKFZ = array(), array $meineVerträgeAusDerPrivatenLebensvorsorge = array(), array $meineVerträgeAusDerBetrieblichenAltersvorsorge = array(), array $weitereVerträgeImBereichLebensvorsorge = array(), \StructType\User $user = null, $startpageLink = null, array $messageHeaders = array(), \StructType\Customer $customer = null, $outstandingPayment = null, array $claim = array(), $hasCustomerAccountPayment = null, $activationNecessary = null, $eCom = null, \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setAdvisor($advisor)
            ->setPossibleAdvisor($possibleAdvisor)
            ->setContractResult($contractResult)
            ->setMeineVerträgeRundUmBesitz($meineVerträgeRundUmBesitz)
            ->setWeitereVerträgeImBereichBesitz($weitereVerträgeImBereichBesitz)
            ->setMeineVerträgeRundUmsBusiness($meineVerträgeRundUmsBusiness)
            ->setWeitereVerträgeImBereichBusiness($weitereVerträgeImBereichBusiness)
            ->setAktiveVerträgeForTypeVNVP_Betrieb($aktiveVerträgeForTypeVNVP_Betrieb)
            ->setAktiveVerträgeForTypeVNVPWVN_Privat($aktiveVerträgeForTypeVNVPWVN_Privat)
            ->setWeitereVerträgeImBereichGesundheit($weitereVerträgeImBereichGesundheit)
            ->setMeineKFZVerträge($meineKFZVerträge)
            ->setWeitereVerträgeImBereichKFZ($weitereVerträgeImBereichKFZ)
            ->setMeineVerträgeAusDerPrivatenLebensvorsorge($meineVerträgeAusDerPrivatenLebensvorsorge)
            ->setMeineVerträgeAusDerBetrieblichenAltersvorsorge($meineVerträgeAusDerBetrieblichenAltersvorsorge)
            ->setWeitereVerträgeImBereichLebensvorsorge($weitereVerträgeImBereichLebensvorsorge)
            ->setUser($user)
            ->setStartpageLink($startpageLink)
            ->setMessageHeaders($messageHeaders)
            ->setCustomer($customer)
            ->setOutstandingPayment($outstandingPayment)
            ->setClaim($claim)
            ->setHasCustomerAccountPayment($hasCustomerAccountPayment)
            ->setActivationNecessary($activationNecessary)
            ->setECom($eCom)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get advisor value
     * @return \StructType\Advisor
     */
    public function getAdvisor()
    {
        return $this->advisor;
    }
    /**
     * Set advisor value
     * @param \StructType\Advisor $advisor
     * @return \StructType\KundenportalDataResponse
     */
    public function setAdvisor(\StructType\Advisor $advisor = null)
    {
        $this->advisor = $advisor;
        return $this;
    }
    /**
     * Get possibleAdvisor value
     * @return \StructType\Advisor[]
     */
    public function getPossibleAdvisor()
    {
        return $this->possibleAdvisor;
    }
    /**
     * This method is responsible for validating the values passed to the setPossibleAdvisor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPossibleAdvisor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePossibleAdvisorForArrayConstraintsFromSetPossibleAdvisor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponsePossibleAdvisorItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponsePossibleAdvisorItem instanceof \StructType\Advisor) {
                $invalidValues[] = is_object($kundenportalDataResponsePossibleAdvisorItem) ? get_class($kundenportalDataResponsePossibleAdvisorItem) : sprintf('%s(%s)', gettype($kundenportalDataResponsePossibleAdvisorItem), var_export($kundenportalDataResponsePossibleAdvisorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The possibleAdvisor property can only contain items of type \StructType\Advisor, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set possibleAdvisor value
     * @throws \InvalidArgumentException
     * @param \StructType\Advisor[] $possibleAdvisor
     * @return \StructType\KundenportalDataResponse
     */
    public function setPossibleAdvisor(array $possibleAdvisor = array())
    {
        // validation for constraint: array
        if ('' !== ($possibleAdvisorArrayErrorMessage = self::validatePossibleAdvisorForArrayConstraintsFromSetPossibleAdvisor($possibleAdvisor))) {
            throw new \InvalidArgumentException($possibleAdvisorArrayErrorMessage, __LINE__);
        }
        $this->possibleAdvisor = $possibleAdvisor;
        return $this;
    }
    /**
     * Add item to possibleAdvisor value
     * @throws \InvalidArgumentException
     * @param \StructType\Advisor $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToPossibleAdvisor(\StructType\Advisor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Advisor) {
            throw new \InvalidArgumentException(sprintf('The possibleAdvisor property can only contain items of type \StructType\Advisor, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->possibleAdvisor[] = $item;
        return $this;
    }
    /**
     * Get contractResult value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getContractResult()
    {
        return $this->contractResult;
    }
    /**
     * This method is responsible for validating the values passed to the setContractResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContractResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractResultForArrayConstraintsFromSetContractResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseContractResultItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseContractResultItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseContractResultItem) ? get_class($kundenportalDataResponseContractResultItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseContractResultItem), var_export($kundenportalDataResponseContractResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contractResult property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contractResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $contractResult
     * @return \StructType\KundenportalDataResponse
     */
    public function setContractResult(array $contractResult = array())
    {
        // validation for constraint: array
        if ('' !== ($contractResultArrayErrorMessage = self::validateContractResultForArrayConstraintsFromSetContractResult($contractResult))) {
            throw new \InvalidArgumentException($contractResultArrayErrorMessage, __LINE__);
        }
        $this->contractResult = $contractResult;
        return $this;
    }
    /**
     * Add item to contractResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToContractResult(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The contractResult property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contractResult[] = $item;
        return $this;
    }
    /**
     * Get meineVerträgeRundUmBesitz value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getMeineVerträgeRundUmBesitz()
    {
        return $this->meineVerträgeRundUmBesitz;
    }
    /**
     * This method is responsible for validating the values passed to the setMeineVerträgeRundUmBesitz method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeineVerträgeRundUmBesitz method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeineVerträgeRundUmBesitzForArrayConstraintsFromSetMeineVerträgeRundUmBesitz(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseMeineVerträgeRundUmBesitzItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseMeineVerträgeRundUmBesitzItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseMeineVerträgeRundUmBesitzItem) ? get_class($kundenportalDataResponseMeineVerträgeRundUmBesitzItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseMeineVerträgeRundUmBesitzItem), var_export($kundenportalDataResponseMeineVerträgeRundUmBesitzItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The meineVerträgeRundUmBesitz property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set meineVerträgeRundUmBesitz value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $meineVerträgeRundUmBesitz
     * @return \StructType\KundenportalDataResponse
     */
    public function setMeineVerträgeRundUmBesitz(array $meineVerträgeRundUmBesitz = array())
    {
        // validation for constraint: array
        if ('' !== ($meineVerträgeRundUmBesitzArrayErrorMessage = self::validateMeineVerträgeRundUmBesitzForArrayConstraintsFromSetMeineVerträgeRundUmBesitz($meineVerträgeRundUmBesitz))) {
            throw new \InvalidArgumentException($meineVerträgeRundUmBesitzArrayErrorMessage, __LINE__);
        }
        $this->meineVerträgeRundUmBesitz = $meineVerträgeRundUmBesitz;
        return $this;
    }
    /**
     * Add item to meineVerträgeRundUmBesitz value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToMeineVerträgeRundUmBesitz(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The meineVerträgeRundUmBesitz property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->meineVerträgeRundUmBesitz[] = $item;
        return $this;
    }
    /**
     * Get weitereVerträgeImBereichBesitz value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getWeitereVerträgeImBereichBesitz()
    {
        return $this->weitereVerträgeImBereichBesitz;
    }
    /**
     * This method is responsible for validating the values passed to the setWeitereVerträgeImBereichBesitz method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeitereVerträgeImBereichBesitz method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeitereVerträgeImBereichBesitzForArrayConstraintsFromSetWeitereVerträgeImBereichBesitz(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseWeitereVerträgeImBereichBesitzItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseWeitereVerträgeImBereichBesitzItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseWeitereVerträgeImBereichBesitzItem) ? get_class($kundenportalDataResponseWeitereVerträgeImBereichBesitzItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseWeitereVerträgeImBereichBesitzItem), var_export($kundenportalDataResponseWeitereVerträgeImBereichBesitzItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weitereVerträgeImBereichBesitz property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weitereVerträgeImBereichBesitz value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichBesitz
     * @return \StructType\KundenportalDataResponse
     */
    public function setWeitereVerträgeImBereichBesitz(array $weitereVerträgeImBereichBesitz = array())
    {
        // validation for constraint: array
        if ('' !== ($weitereVerträgeImBereichBesitzArrayErrorMessage = self::validateWeitereVerträgeImBereichBesitzForArrayConstraintsFromSetWeitereVerträgeImBereichBesitz($weitereVerträgeImBereichBesitz))) {
            throw new \InvalidArgumentException($weitereVerträgeImBereichBesitzArrayErrorMessage, __LINE__);
        }
        $this->weitereVerträgeImBereichBesitz = $weitereVerträgeImBereichBesitz;
        return $this;
    }
    /**
     * Add item to weitereVerträgeImBereichBesitz value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToWeitereVerträgeImBereichBesitz(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The weitereVerträgeImBereichBesitz property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weitereVerträgeImBereichBesitz[] = $item;
        return $this;
    }
    /**
     * Get meineVerträgeRundUmsBusiness value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getMeineVerträgeRundUmsBusiness()
    {
        return $this->meineVerträgeRundUmsBusiness;
    }
    /**
     * This method is responsible for validating the values passed to the setMeineVerträgeRundUmsBusiness method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeineVerträgeRundUmsBusiness method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeineVerträgeRundUmsBusinessForArrayConstraintsFromSetMeineVerträgeRundUmsBusiness(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseMeineVerträgeRundUmsBusinessItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseMeineVerträgeRundUmsBusinessItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseMeineVerträgeRundUmsBusinessItem) ? get_class($kundenportalDataResponseMeineVerträgeRundUmsBusinessItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseMeineVerträgeRundUmsBusinessItem), var_export($kundenportalDataResponseMeineVerträgeRundUmsBusinessItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The meineVerträgeRundUmsBusiness property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set meineVerträgeRundUmsBusiness value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $meineVerträgeRundUmsBusiness
     * @return \StructType\KundenportalDataResponse
     */
    public function setMeineVerträgeRundUmsBusiness(array $meineVerträgeRundUmsBusiness = array())
    {
        // validation for constraint: array
        if ('' !== ($meineVerträgeRundUmsBusinessArrayErrorMessage = self::validateMeineVerträgeRundUmsBusinessForArrayConstraintsFromSetMeineVerträgeRundUmsBusiness($meineVerträgeRundUmsBusiness))) {
            throw new \InvalidArgumentException($meineVerträgeRundUmsBusinessArrayErrorMessage, __LINE__);
        }
        $this->meineVerträgeRundUmsBusiness = $meineVerträgeRundUmsBusiness;
        return $this;
    }
    /**
     * Add item to meineVerträgeRundUmsBusiness value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToMeineVerträgeRundUmsBusiness(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The meineVerträgeRundUmsBusiness property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->meineVerträgeRundUmsBusiness[] = $item;
        return $this;
    }
    /**
     * Get weitereVerträgeImBereichBusiness value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getWeitereVerträgeImBereichBusiness()
    {
        return $this->weitereVerträgeImBereichBusiness;
    }
    /**
     * This method is responsible for validating the values passed to the setWeitereVerträgeImBereichBusiness method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeitereVerträgeImBereichBusiness method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeitereVerträgeImBereichBusinessForArrayConstraintsFromSetWeitereVerträgeImBereichBusiness(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseWeitereVerträgeImBereichBusinessItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseWeitereVerträgeImBereichBusinessItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseWeitereVerträgeImBereichBusinessItem) ? get_class($kundenportalDataResponseWeitereVerträgeImBereichBusinessItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseWeitereVerträgeImBereichBusinessItem), var_export($kundenportalDataResponseWeitereVerträgeImBereichBusinessItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weitereVerträgeImBereichBusiness property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weitereVerträgeImBereichBusiness value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichBusiness
     * @return \StructType\KundenportalDataResponse
     */
    public function setWeitereVerträgeImBereichBusiness(array $weitereVerträgeImBereichBusiness = array())
    {
        // validation for constraint: array
        if ('' !== ($weitereVerträgeImBereichBusinessArrayErrorMessage = self::validateWeitereVerträgeImBereichBusinessForArrayConstraintsFromSetWeitereVerträgeImBereichBusiness($weitereVerträgeImBereichBusiness))) {
            throw new \InvalidArgumentException($weitereVerträgeImBereichBusinessArrayErrorMessage, __LINE__);
        }
        $this->weitereVerträgeImBereichBusiness = $weitereVerträgeImBereichBusiness;
        return $this;
    }
    /**
     * Add item to weitereVerträgeImBereichBusiness value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToWeitereVerträgeImBereichBusiness(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The weitereVerträgeImBereichBusiness property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weitereVerträgeImBereichBusiness[] = $item;
        return $this;
    }
    /**
     * Get aktiveVerträgeForTypeVNVP_Betrieb value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getAktiveVerträgeForTypeVNVP_Betrieb()
    {
        return $this->aktiveVerträgeForTypeVNVP_Betrieb;
    }
    /**
     * This method is responsible for validating the values passed to the setAktiveVerträgeForTypeVNVP_Betrieb method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAktiveVerträgeForTypeVNVP_Betrieb method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAktiveVerträgeForTypeVNVP_BetriebForArrayConstraintsFromSetAktiveVerträgeForTypeVNVP_Betrieb(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseAktiveVerträgeForTypeVNVP_BetriebItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseAktiveVerträgeForTypeVNVP_BetriebItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseAktiveVerträgeForTypeVNVP_BetriebItem) ? get_class($kundenportalDataResponseAktiveVerträgeForTypeVNVP_BetriebItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseAktiveVerträgeForTypeVNVP_BetriebItem), var_export($kundenportalDataResponseAktiveVerträgeForTypeVNVP_BetriebItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aktiveVerträgeForTypeVNVP_Betrieb property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aktiveVerträgeForTypeVNVP_Betrieb value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $aktiveVerträgeForTypeVNVP_Betrieb
     * @return \StructType\KundenportalDataResponse
     */
    public function setAktiveVerträgeForTypeVNVP_Betrieb(array $aktiveVerträgeForTypeVNVP_Betrieb = array())
    {
        // validation for constraint: array
        if ('' !== ($aktiveVerträgeForTypeVNVP_BetriebArrayErrorMessage = self::validateAktiveVerträgeForTypeVNVP_BetriebForArrayConstraintsFromSetAktiveVerträgeForTypeVNVP_Betrieb($aktiveVerträgeForTypeVNVP_Betrieb))) {
            throw new \InvalidArgumentException($aktiveVerträgeForTypeVNVP_BetriebArrayErrorMessage, __LINE__);
        }
        $this->aktiveVerträgeForTypeVNVP_Betrieb = $aktiveVerträgeForTypeVNVP_Betrieb;
        return $this;
    }
    /**
     * Add item to aktiveVerträgeForTypeVNVP_Betrieb value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToAktiveVerträgeForTypeVNVP_Betrieb(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The aktiveVerträgeForTypeVNVP_Betrieb property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aktiveVerträgeForTypeVNVP_Betrieb[] = $item;
        return $this;
    }
    /**
     * Get aktiveVerträgeForTypeVNVPWVN_Privat value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getAktiveVerträgeForTypeVNVPWVN_Privat()
    {
        return $this->aktiveVerträgeForTypeVNVPWVN_Privat;
    }
    /**
     * This method is responsible for validating the values passed to the setAktiveVerträgeForTypeVNVPWVN_Privat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAktiveVerträgeForTypeVNVPWVN_Privat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAktiveVerträgeForTypeVNVPWVN_PrivatForArrayConstraintsFromSetAktiveVerträgeForTypeVNVPWVN_Privat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseAktiveVerträgeForTypeVNVPWVN_PrivatItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseAktiveVerträgeForTypeVNVPWVN_PrivatItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseAktiveVerträgeForTypeVNVPWVN_PrivatItem) ? get_class($kundenportalDataResponseAktiveVerträgeForTypeVNVPWVN_PrivatItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseAktiveVerträgeForTypeVNVPWVN_PrivatItem), var_export($kundenportalDataResponseAktiveVerträgeForTypeVNVPWVN_PrivatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aktiveVerträgeForTypeVNVPWVN_Privat property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aktiveVerträgeForTypeVNVPWVN_Privat value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $aktiveVerträgeForTypeVNVPWVN_Privat
     * @return \StructType\KundenportalDataResponse
     */
    public function setAktiveVerträgeForTypeVNVPWVN_Privat(array $aktiveVerträgeForTypeVNVPWVN_Privat = array())
    {
        // validation for constraint: array
        if ('' !== ($aktiveVerträgeForTypeVNVPWVN_PrivatArrayErrorMessage = self::validateAktiveVerträgeForTypeVNVPWVN_PrivatForArrayConstraintsFromSetAktiveVerträgeForTypeVNVPWVN_Privat($aktiveVerträgeForTypeVNVPWVN_Privat))) {
            throw new \InvalidArgumentException($aktiveVerträgeForTypeVNVPWVN_PrivatArrayErrorMessage, __LINE__);
        }
        $this->aktiveVerträgeForTypeVNVPWVN_Privat = $aktiveVerträgeForTypeVNVPWVN_Privat;
        return $this;
    }
    /**
     * Add item to aktiveVerträgeForTypeVNVPWVN_Privat value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToAktiveVerträgeForTypeVNVPWVN_Privat(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The aktiveVerträgeForTypeVNVPWVN_Privat property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aktiveVerträgeForTypeVNVPWVN_Privat[] = $item;
        return $this;
    }
    /**
     * Get weitereVerträgeImBereichGesundheit value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getWeitereVerträgeImBereichGesundheit()
    {
        return $this->weitereVerträgeImBereichGesundheit;
    }
    /**
     * This method is responsible for validating the values passed to the setWeitereVerträgeImBereichGesundheit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeitereVerträgeImBereichGesundheit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeitereVerträgeImBereichGesundheitForArrayConstraintsFromSetWeitereVerträgeImBereichGesundheit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseWeitereVerträgeImBereichGesundheitItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseWeitereVerträgeImBereichGesundheitItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseWeitereVerträgeImBereichGesundheitItem) ? get_class($kundenportalDataResponseWeitereVerträgeImBereichGesundheitItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseWeitereVerträgeImBereichGesundheitItem), var_export($kundenportalDataResponseWeitereVerträgeImBereichGesundheitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weitereVerträgeImBereichGesundheit property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weitereVerträgeImBereichGesundheit value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichGesundheit
     * @return \StructType\KundenportalDataResponse
     */
    public function setWeitereVerträgeImBereichGesundheit(array $weitereVerträgeImBereichGesundheit = array())
    {
        // validation for constraint: array
        if ('' !== ($weitereVerträgeImBereichGesundheitArrayErrorMessage = self::validateWeitereVerträgeImBereichGesundheitForArrayConstraintsFromSetWeitereVerträgeImBereichGesundheit($weitereVerträgeImBereichGesundheit))) {
            throw new \InvalidArgumentException($weitereVerträgeImBereichGesundheitArrayErrorMessage, __LINE__);
        }
        $this->weitereVerträgeImBereichGesundheit = $weitereVerträgeImBereichGesundheit;
        return $this;
    }
    /**
     * Add item to weitereVerträgeImBereichGesundheit value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToWeitereVerträgeImBereichGesundheit(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The weitereVerträgeImBereichGesundheit property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weitereVerträgeImBereichGesundheit[] = $item;
        return $this;
    }
    /**
     * Get meineKFZVerträge value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getMeineKFZVerträge()
    {
        return $this->meineKFZVerträge;
    }
    /**
     * This method is responsible for validating the values passed to the setMeineKFZVerträge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeineKFZVerträge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeineKFZVerträgeForArrayConstraintsFromSetMeineKFZVerträge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseMeineKFZVerträgeItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseMeineKFZVerträgeItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseMeineKFZVerträgeItem) ? get_class($kundenportalDataResponseMeineKFZVerträgeItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseMeineKFZVerträgeItem), var_export($kundenportalDataResponseMeineKFZVerträgeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The meineKFZVerträge property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set meineKFZVerträge value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $meineKFZVerträge
     * @return \StructType\KundenportalDataResponse
     */
    public function setMeineKFZVerträge(array $meineKFZVerträge = array())
    {
        // validation for constraint: array
        if ('' !== ($meineKFZVerträgeArrayErrorMessage = self::validateMeineKFZVerträgeForArrayConstraintsFromSetMeineKFZVerträge($meineKFZVerträge))) {
            throw new \InvalidArgumentException($meineKFZVerträgeArrayErrorMessage, __LINE__);
        }
        $this->meineKFZVerträge = $meineKFZVerträge;
        return $this;
    }
    /**
     * Add item to meineKFZVerträge value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToMeineKFZVerträge(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The meineKFZVerträge property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->meineKFZVerträge[] = $item;
        return $this;
    }
    /**
     * Get weitereVerträgeImBereichKFZ value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getWeitereVerträgeImBereichKFZ()
    {
        return $this->weitereVerträgeImBereichKFZ;
    }
    /**
     * This method is responsible for validating the values passed to the setWeitereVerträgeImBereichKFZ method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeitereVerträgeImBereichKFZ method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeitereVerträgeImBereichKFZForArrayConstraintsFromSetWeitereVerträgeImBereichKFZ(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseWeitereVerträgeImBereichKFZItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseWeitereVerträgeImBereichKFZItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseWeitereVerträgeImBereichKFZItem) ? get_class($kundenportalDataResponseWeitereVerträgeImBereichKFZItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseWeitereVerträgeImBereichKFZItem), var_export($kundenportalDataResponseWeitereVerträgeImBereichKFZItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weitereVerträgeImBereichKFZ property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weitereVerträgeImBereichKFZ value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichKFZ
     * @return \StructType\KundenportalDataResponse
     */
    public function setWeitereVerträgeImBereichKFZ(array $weitereVerträgeImBereichKFZ = array())
    {
        // validation for constraint: array
        if ('' !== ($weitereVerträgeImBereichKFZArrayErrorMessage = self::validateWeitereVerträgeImBereichKFZForArrayConstraintsFromSetWeitereVerträgeImBereichKFZ($weitereVerträgeImBereichKFZ))) {
            throw new \InvalidArgumentException($weitereVerträgeImBereichKFZArrayErrorMessage, __LINE__);
        }
        $this->weitereVerträgeImBereichKFZ = $weitereVerträgeImBereichKFZ;
        return $this;
    }
    /**
     * Add item to weitereVerträgeImBereichKFZ value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToWeitereVerträgeImBereichKFZ(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The weitereVerträgeImBereichKFZ property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weitereVerträgeImBereichKFZ[] = $item;
        return $this;
    }
    /**
     * Get meineVerträgeAusDerPrivatenLebensvorsorge value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getMeineVerträgeAusDerPrivatenLebensvorsorge()
    {
        return $this->meineVerträgeAusDerPrivatenLebensvorsorge;
    }
    /**
     * This method is responsible for validating the values passed to the setMeineVerträgeAusDerPrivatenLebensvorsorge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeineVerträgeAusDerPrivatenLebensvorsorge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeineVerträgeAusDerPrivatenLebensvorsorgeForArrayConstraintsFromSetMeineVerträgeAusDerPrivatenLebensvorsorge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseMeineVerträgeAusDerPrivatenLebensvorsorgeItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseMeineVerträgeAusDerPrivatenLebensvorsorgeItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseMeineVerträgeAusDerPrivatenLebensvorsorgeItem) ? get_class($kundenportalDataResponseMeineVerträgeAusDerPrivatenLebensvorsorgeItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseMeineVerträgeAusDerPrivatenLebensvorsorgeItem), var_export($kundenportalDataResponseMeineVerträgeAusDerPrivatenLebensvorsorgeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The meineVerträgeAusDerPrivatenLebensvorsorge property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set meineVerträgeAusDerPrivatenLebensvorsorge value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $meineVerträgeAusDerPrivatenLebensvorsorge
     * @return \StructType\KundenportalDataResponse
     */
    public function setMeineVerträgeAusDerPrivatenLebensvorsorge(array $meineVerträgeAusDerPrivatenLebensvorsorge = array())
    {
        // validation for constraint: array
        if ('' !== ($meineVerträgeAusDerPrivatenLebensvorsorgeArrayErrorMessage = self::validateMeineVerträgeAusDerPrivatenLebensvorsorgeForArrayConstraintsFromSetMeineVerträgeAusDerPrivatenLebensvorsorge($meineVerträgeAusDerPrivatenLebensvorsorge))) {
            throw new \InvalidArgumentException($meineVerträgeAusDerPrivatenLebensvorsorgeArrayErrorMessage, __LINE__);
        }
        $this->meineVerträgeAusDerPrivatenLebensvorsorge = $meineVerträgeAusDerPrivatenLebensvorsorge;
        return $this;
    }
    /**
     * Add item to meineVerträgeAusDerPrivatenLebensvorsorge value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToMeineVerträgeAusDerPrivatenLebensvorsorge(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The meineVerträgeAusDerPrivatenLebensvorsorge property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->meineVerträgeAusDerPrivatenLebensvorsorge[] = $item;
        return $this;
    }
    /**
     * Get meineVerträgeAusDerBetrieblichenAltersvorsorge value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getMeineVerträgeAusDerBetrieblichenAltersvorsorge()
    {
        return $this->meineVerträgeAusDerBetrieblichenAltersvorsorge;
    }
    /**
     * This method is responsible for validating the values passed to the setMeineVerträgeAusDerBetrieblichenAltersvorsorge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeineVerträgeAusDerBetrieblichenAltersvorsorge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeineVerträgeAusDerBetrieblichenAltersvorsorgeForArrayConstraintsFromSetMeineVerträgeAusDerBetrieblichenAltersvorsorge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseMeineVerträgeAusDerBetrieblichenAltersvorsorgeItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseMeineVerträgeAusDerBetrieblichenAltersvorsorgeItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseMeineVerträgeAusDerBetrieblichenAltersvorsorgeItem) ? get_class($kundenportalDataResponseMeineVerträgeAusDerBetrieblichenAltersvorsorgeItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseMeineVerträgeAusDerBetrieblichenAltersvorsorgeItem), var_export($kundenportalDataResponseMeineVerträgeAusDerBetrieblichenAltersvorsorgeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The meineVerträgeAusDerBetrieblichenAltersvorsorge property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set meineVerträgeAusDerBetrieblichenAltersvorsorge value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $meineVerträgeAusDerBetrieblichenAltersvorsorge
     * @return \StructType\KundenportalDataResponse
     */
    public function setMeineVerträgeAusDerBetrieblichenAltersvorsorge(array $meineVerträgeAusDerBetrieblichenAltersvorsorge = array())
    {
        // validation for constraint: array
        if ('' !== ($meineVerträgeAusDerBetrieblichenAltersvorsorgeArrayErrorMessage = self::validateMeineVerträgeAusDerBetrieblichenAltersvorsorgeForArrayConstraintsFromSetMeineVerträgeAusDerBetrieblichenAltersvorsorge($meineVerträgeAusDerBetrieblichenAltersvorsorge))) {
            throw new \InvalidArgumentException($meineVerträgeAusDerBetrieblichenAltersvorsorgeArrayErrorMessage, __LINE__);
        }
        $this->meineVerträgeAusDerBetrieblichenAltersvorsorge = $meineVerträgeAusDerBetrieblichenAltersvorsorge;
        return $this;
    }
    /**
     * Add item to meineVerträgeAusDerBetrieblichenAltersvorsorge value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToMeineVerträgeAusDerBetrieblichenAltersvorsorge(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The meineVerträgeAusDerBetrieblichenAltersvorsorge property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->meineVerträgeAusDerBetrieblichenAltersvorsorge[] = $item;
        return $this;
    }
    /**
     * Get weitereVerträgeImBereichLebensvorsorge value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getWeitereVerträgeImBereichLebensvorsorge()
    {
        return $this->weitereVerträgeImBereichLebensvorsorge;
    }
    /**
     * This method is responsible for validating the values passed to the setWeitereVerträgeImBereichLebensvorsorge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeitereVerträgeImBereichLebensvorsorge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeitereVerträgeImBereichLebensvorsorgeForArrayConstraintsFromSetWeitereVerträgeImBereichLebensvorsorge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseWeitereVerträgeImBereichLebensvorsorgeItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseWeitereVerträgeImBereichLebensvorsorgeItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($kundenportalDataResponseWeitereVerträgeImBereichLebensvorsorgeItem) ? get_class($kundenportalDataResponseWeitereVerträgeImBereichLebensvorsorgeItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseWeitereVerträgeImBereichLebensvorsorgeItem), var_export($kundenportalDataResponseWeitereVerträgeImBereichLebensvorsorgeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weitereVerträgeImBereichLebensvorsorge property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weitereVerträgeImBereichLebensvorsorge value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $weitereVerträgeImBereichLebensvorsorge
     * @return \StructType\KundenportalDataResponse
     */
    public function setWeitereVerträgeImBereichLebensvorsorge(array $weitereVerträgeImBereichLebensvorsorge = array())
    {
        // validation for constraint: array
        if ('' !== ($weitereVerträgeImBereichLebensvorsorgeArrayErrorMessage = self::validateWeitereVerträgeImBereichLebensvorsorgeForArrayConstraintsFromSetWeitereVerträgeImBereichLebensvorsorge($weitereVerträgeImBereichLebensvorsorge))) {
            throw new \InvalidArgumentException($weitereVerträgeImBereichLebensvorsorgeArrayErrorMessage, __LINE__);
        }
        $this->weitereVerträgeImBereichLebensvorsorge = $weitereVerträgeImBereichLebensvorsorge;
        return $this;
    }
    /**
     * Add item to weitereVerträgeImBereichLebensvorsorge value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToWeitereVerträgeImBereichLebensvorsorge(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The weitereVerträgeImBereichLebensvorsorge property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weitereVerträgeImBereichLebensvorsorge[] = $item;
        return $this;
    }
    /**
     * Get user value
     * @return \StructType\User|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param \StructType\User $user
     * @return \StructType\KundenportalDataResponse
     */
    public function setUser(\StructType\User $user = null)
    {
        $this->user = $user;
        return $this;
    }
    /**
     * Get startpageLink value
     * @return string|null
     */
    public function getStartpageLink()
    {
        return $this->startpageLink;
    }
    /**
     * Set startpageLink value
     * @param string $startpageLink
     * @return \StructType\KundenportalDataResponse
     */
    public function setStartpageLink($startpageLink = null)
    {
        // validation for constraint: string
        if (!is_null($startpageLink) && !is_string($startpageLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startpageLink, true), gettype($startpageLink)), __LINE__);
        }
        $this->startpageLink = $startpageLink;
        return $this;
    }
    /**
     * Get messageHeaders value
     * @return \StructType\MessageHeader[]|null
     */
    public function getMessageHeaders()
    {
        return $this->messageHeaders;
    }
    /**
     * This method is responsible for validating the values passed to the setMessageHeaders method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessageHeaders method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageHeadersForArrayConstraintsFromSetMessageHeaders(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseMessageHeadersItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseMessageHeadersItem instanceof \StructType\MessageHeader) {
                $invalidValues[] = is_object($kundenportalDataResponseMessageHeadersItem) ? get_class($kundenportalDataResponseMessageHeadersItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseMessageHeadersItem), var_export($kundenportalDataResponseMessageHeadersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The messageHeaders property can only contain items of type \StructType\MessageHeader, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set messageHeaders value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageHeader[] $messageHeaders
     * @return \StructType\KundenportalDataResponse
     */
    public function setMessageHeaders(array $messageHeaders = array())
    {
        // validation for constraint: array
        if ('' !== ($messageHeadersArrayErrorMessage = self::validateMessageHeadersForArrayConstraintsFromSetMessageHeaders($messageHeaders))) {
            throw new \InvalidArgumentException($messageHeadersArrayErrorMessage, __LINE__);
        }
        $this->messageHeaders = $messageHeaders;
        return $this;
    }
    /**
     * Add item to messageHeaders value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageHeader $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToMessageHeaders(\StructType\MessageHeader $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MessageHeader) {
            throw new \InvalidArgumentException(sprintf('The messageHeaders property can only contain items of type \StructType\MessageHeader, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->messageHeaders[] = $item;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\KundenportalDataResponse
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get outstandingPayment value
     * @return bool|null
     */
    public function getOutstandingPayment()
    {
        return $this->outstandingPayment;
    }
    /**
     * Set outstandingPayment value
     * @param bool $outstandingPayment
     * @return \StructType\KundenportalDataResponse
     */
    public function setOutstandingPayment($outstandingPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($outstandingPayment) && !is_bool($outstandingPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($outstandingPayment, true), gettype($outstandingPayment)), __LINE__);
        }
        $this->outstandingPayment = $outstandingPayment;
        return $this;
    }
    /**
     * Get claim value
     * @return \StructType\Claim[]|null
     */
    public function getClaim()
    {
        return $this->claim;
    }
    /**
     * This method is responsible for validating the values passed to the setClaim method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaim method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClaimForArrayConstraintsFromSetClaim(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalDataResponseClaimItem) {
            // validation for constraint: itemType
            if (!$kundenportalDataResponseClaimItem instanceof \StructType\Claim) {
                $invalidValues[] = is_object($kundenportalDataResponseClaimItem) ? get_class($kundenportalDataResponseClaimItem) : sprintf('%s(%s)', gettype($kundenportalDataResponseClaimItem), var_export($kundenportalDataResponseClaimItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The claim property can only contain items of type \StructType\Claim, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set claim value
     * @throws \InvalidArgumentException
     * @param \StructType\Claim[] $claim
     * @return \StructType\KundenportalDataResponse
     */
    public function setClaim(array $claim = array())
    {
        // validation for constraint: array
        if ('' !== ($claimArrayErrorMessage = self::validateClaimForArrayConstraintsFromSetClaim($claim))) {
            throw new \InvalidArgumentException($claimArrayErrorMessage, __LINE__);
        }
        $this->claim = $claim;
        return $this;
    }
    /**
     * Add item to claim value
     * @throws \InvalidArgumentException
     * @param \StructType\Claim $item
     * @return \StructType\KundenportalDataResponse
     */
    public function addToClaim(\StructType\Claim $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Claim) {
            throw new \InvalidArgumentException(sprintf('The claim property can only contain items of type \StructType\Claim, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->claim[] = $item;
        return $this;
    }
    /**
     * Get hasCustomerAccountPayment value
     * @return bool|null
     */
    public function getHasCustomerAccountPayment()
    {
        return $this->hasCustomerAccountPayment;
    }
    /**
     * Set hasCustomerAccountPayment value
     * @param bool $hasCustomerAccountPayment
     * @return \StructType\KundenportalDataResponse
     */
    public function setHasCustomerAccountPayment($hasCustomerAccountPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasCustomerAccountPayment) && !is_bool($hasCustomerAccountPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasCustomerAccountPayment, true), gettype($hasCustomerAccountPayment)), __LINE__);
        }
        $this->hasCustomerAccountPayment = $hasCustomerAccountPayment;
        return $this;
    }
    /**
     * Get activationNecessary value
     * @return bool|null
     */
    public function getActivationNecessary()
    {
        return $this->activationNecessary;
    }
    /**
     * Set activationNecessary value
     * @param bool $activationNecessary
     * @return \StructType\KundenportalDataResponse
     */
    public function setActivationNecessary($activationNecessary = null)
    {
        // validation for constraint: boolean
        if (!is_null($activationNecessary) && !is_bool($activationNecessary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activationNecessary, true), gettype($activationNecessary)), __LINE__);
        }
        $this->activationNecessary = $activationNecessary;
        return $this;
    }
    /**
     * Get eCom value
     * @return bool|null
     */
    public function getECom()
    {
        return $this->eCom;
    }
    /**
     * Set eCom value
     * @param bool $eCom
     * @return \StructType\KundenportalDataResponse
     */
    public function setECom($eCom = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCom) && !is_bool($eCom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCom, true), gettype($eCom)), __LINE__);
        }
        $this->eCom = $eCom;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\KundenportalDataResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalDataResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
