<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for insassenunfallType StructType
 * @subpackage Structs
 */
class InsassenunfallType extends AbstractStructBase
{
    /**
     * The versicherungsart
     * @var string
     */
    public $versicherungsart;
    /**
     * The einschraenkungLenker
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $einschraenkungLenker;
    /**
     * The dauerinvaliditaet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dauerinvaliditaet;
    /**
     * The tod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tod;
    /**
     * The taggeld
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $taggeld;
    /**
     * The heilkosten
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $heilkosten;
    /**
     * Constructor method for insassenunfallType
     * @uses InsassenunfallType::setVersicherungsart()
     * @uses InsassenunfallType::setEinschraenkungLenker()
     * @uses InsassenunfallType::setDauerinvaliditaet()
     * @uses InsassenunfallType::setTod()
     * @uses InsassenunfallType::setTaggeld()
     * @uses InsassenunfallType::setHeilkosten()
     * @param string $versicherungsart
     * @param string $einschraenkungLenker
     * @param int $dauerinvaliditaet
     * @param int $tod
     * @param int $taggeld
     * @param int $heilkosten
     */
    public function __construct($versicherungsart = null, $einschraenkungLenker = null, $dauerinvaliditaet = null, $tod = null, $taggeld = null, $heilkosten = null)
    {
        $this
            ->setVersicherungsart($versicherungsart)
            ->setEinschraenkungLenker($einschraenkungLenker)
            ->setDauerinvaliditaet($dauerinvaliditaet)
            ->setTod($tod)
            ->setTaggeld($taggeld)
            ->setHeilkosten($heilkosten);
    }
    /**
     * Get versicherungsart value
     * @return string|null
     */
    public function getVersicherungsart()
    {
        return $this->versicherungsart;
    }
    /**
     * Set versicherungsart value
     * @uses \EnumType\IuVersicherungsartType::valueIsValid()
     * @uses \EnumType\IuVersicherungsartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $versicherungsart
     * @return \StructType\InsassenunfallType
     */
    public function setVersicherungsart($versicherungsart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IuVersicherungsartType::valueIsValid($versicherungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IuVersicherungsartType', is_array($versicherungsart) ? implode(', ', $versicherungsart) : var_export($versicherungsart, true), implode(', ', \EnumType\IuVersicherungsartType::getValidValues())), __LINE__);
        }
        $this->versicherungsart = $versicherungsart;
        return $this;
    }
    /**
     * Get einschraenkungLenker value
     * @return string|null
     */
    public function getEinschraenkungLenker()
    {
        return $this->einschraenkungLenker;
    }
    /**
     * Set einschraenkungLenker value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $einschraenkungLenker
     * @return \StructType\InsassenunfallType
     */
    public function setEinschraenkungLenker($einschraenkungLenker = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($einschraenkungLenker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($einschraenkungLenker) ? implode(', ', $einschraenkungLenker) : var_export($einschraenkungLenker, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->einschraenkungLenker = $einschraenkungLenker;
        return $this;
    }
    /**
     * Get dauerinvaliditaet value
     * @return int|null
     */
    public function getDauerinvaliditaet()
    {
        return $this->dauerinvaliditaet;
    }
    /**
     * Set dauerinvaliditaet value
     * @param int $dauerinvaliditaet
     * @return \StructType\InsassenunfallType
     */
    public function setDauerinvaliditaet($dauerinvaliditaet = null)
    {
        // validation for constraint: int
        if (!is_null($dauerinvaliditaet) && !(is_int($dauerinvaliditaet) || ctype_digit($dauerinvaliditaet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dauerinvaliditaet, true), gettype($dauerinvaliditaet)), __LINE__);
        }
        $this->dauerinvaliditaet = $dauerinvaliditaet;
        return $this;
    }
    /**
     * Get tod value
     * @return int|null
     */
    public function getTod()
    {
        return $this->tod;
    }
    /**
     * Set tod value
     * @param int $tod
     * @return \StructType\InsassenunfallType
     */
    public function setTod($tod = null)
    {
        // validation for constraint: int
        if (!is_null($tod) && !(is_int($tod) || ctype_digit($tod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tod, true), gettype($tod)), __LINE__);
        }
        $this->tod = $tod;
        return $this;
    }
    /**
     * Get taggeld value
     * @return int|null
     */
    public function getTaggeld()
    {
        return $this->taggeld;
    }
    /**
     * Set taggeld value
     * @param int $taggeld
     * @return \StructType\InsassenunfallType
     */
    public function setTaggeld($taggeld = null)
    {
        // validation for constraint: int
        if (!is_null($taggeld) && !(is_int($taggeld) || ctype_digit($taggeld))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taggeld, true), gettype($taggeld)), __LINE__);
        }
        $this->taggeld = $taggeld;
        return $this;
    }
    /**
     * Get heilkosten value
     * @return int|null
     */
    public function getHeilkosten()
    {
        return $this->heilkosten;
    }
    /**
     * Set heilkosten value
     * @param int $heilkosten
     * @return \StructType\InsassenunfallType
     */
    public function setHeilkosten($heilkosten = null)
    {
        // validation for constraint: int
        if (!is_null($heilkosten) && !(is_int($heilkosten) || ctype_digit($heilkosten))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heilkosten, true), gettype($heilkosten)), __LINE__);
        }
        $this->heilkosten = $heilkosten;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsassenunfallType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
