<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Identification StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifikationsnachweis
 * @subpackage Structs
 */
class Identification extends AbstractStructBase
{
    /**
     * The identificationType
     * Meta information extracted from the WSDL
     * - documentation: Typ des Identitätsnachweises 1..Polizzennummer 2..Firmenbuchauszug 3..Führerschein 4..Personalausweis 5..Reisepass
     * @var int
     */
    public $identificationType;
    /**
     * The identificationNumber
     * Meta information extracted from the WSDL
     * - documentation: z.B. Führerscheinnr., Reisepassnr.
     * - base: xsd:string
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $identificationNumber;
    /**
     * The identificationDate
     * Meta information extracted from the WSDL
     * - documentation: Ausstellungsdatum
     * - minOccurs: 0
     * @var string
     */
    public $identificationDate;
    /**
     * The identificationValidUntil
     * Meta information extracted from the WSDL
     * - documentation: Gülitg-Bis Datum des Ausweises
     * - minOccurs: 0
     * @var string
     */
    public $identificationValidUntil;
    /**
     * The authority
     * Meta information extracted from the WSDL
     * - documentation: Ausstellende Behörde (z.B. BPD Wien)
     * - base: xsd:string
     * - maxLength: 25
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $authority;
    /**
     * The identificationInformation
     * Meta information extracted from the WSDL
     * - documentation: Sonstige Informationen zum Identitätsnachweis
     * - base: xsd:string
     * - maxLength: 80
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $identificationInformation;
    /**
     * The ausstellungsland
     * Meta information extracted from the WSDL
     * - documentation: Ausstellungsland des Identitätsnachweises
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $ausstellungsland;
    /**
     * The dateOfEntry
     * Meta information extracted from the WSDL
     * - documentation: Erfassungsdatum
     * - minOccurs: 0
     * @var string
     */
    public $dateOfEntry;
    /**
     * Constructor method for Identification
     * @uses Identification::setIdentificationType()
     * @uses Identification::setIdentificationNumber()
     * @uses Identification::setIdentificationDate()
     * @uses Identification::setIdentificationValidUntil()
     * @uses Identification::setAuthority()
     * @uses Identification::setIdentificationInformation()
     * @uses Identification::setAusstellungsland()
     * @uses Identification::setDateOfEntry()
     * @param int $identificationType
     * @param string $identificationNumber
     * @param string $identificationDate
     * @param string $identificationValidUntil
     * @param string $authority
     * @param string $identificationInformation
     * @param \StructType\Country $ausstellungsland
     * @param string $dateOfEntry
     */
    public function __construct($identificationType = null, $identificationNumber = null, $identificationDate = null, $identificationValidUntil = null, $authority = null, $identificationInformation = null, \StructType\Country $ausstellungsland = null, $dateOfEntry = null)
    {
        $this
            ->setIdentificationType($identificationType)
            ->setIdentificationNumber($identificationNumber)
            ->setIdentificationDate($identificationDate)
            ->setIdentificationValidUntil($identificationValidUntil)
            ->setAuthority($authority)
            ->setIdentificationInformation($identificationInformation)
            ->setAusstellungsland($ausstellungsland)
            ->setDateOfEntry($dateOfEntry);
    }
    /**
     * Get identificationType value
     * @return int|null
     */
    public function getIdentificationType()
    {
        return $this->identificationType;
    }
    /**
     * Set identificationType value
     * @param int $identificationType
     * @return \StructType\Identification
     */
    public function setIdentificationType($identificationType = null)
    {
        // validation for constraint: int
        if (!is_null($identificationType) && !(is_int($identificationType) || ctype_digit($identificationType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identificationType, true), gettype($identificationType)), __LINE__);
        }
        $this->identificationType = $identificationType;
        return $this;
    }
    /**
     * Get identificationNumber value
     * @return string|null
     */
    public function getIdentificationNumber()
    {
        return $this->identificationNumber;
    }
    /**
     * Set identificationNumber value
     * @param string $identificationNumber
     * @return \StructType\Identification
     */
    public function setIdentificationNumber($identificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNumber) && !is_string($identificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNumber, true), gettype($identificationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($identificationNumber) && mb_strlen($identificationNumber) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($identificationNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($identificationNumber) && mb_strlen($identificationNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($identificationNumber)), __LINE__);
        }
        $this->identificationNumber = $identificationNumber;
        return $this;
    }
    /**
     * Get identificationDate value
     * @return string|null
     */
    public function getIdentificationDate()
    {
        return $this->identificationDate;
    }
    /**
     * Set identificationDate value
     * @param string $identificationDate
     * @return \StructType\Identification
     */
    public function setIdentificationDate($identificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($identificationDate) && !is_string($identificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationDate, true), gettype($identificationDate)), __LINE__);
        }
        $this->identificationDate = $identificationDate;
        return $this;
    }
    /**
     * Get identificationValidUntil value
     * @return string|null
     */
    public function getIdentificationValidUntil()
    {
        return $this->identificationValidUntil;
    }
    /**
     * Set identificationValidUntil value
     * @param string $identificationValidUntil
     * @return \StructType\Identification
     */
    public function setIdentificationValidUntil($identificationValidUntil = null)
    {
        // validation for constraint: string
        if (!is_null($identificationValidUntil) && !is_string($identificationValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationValidUntil, true), gettype($identificationValidUntil)), __LINE__);
        }
        $this->identificationValidUntil = $identificationValidUntil;
        return $this;
    }
    /**
     * Get authority value
     * @return string|null
     */
    public function getAuthority()
    {
        return $this->authority;
    }
    /**
     * Set authority value
     * @param string $authority
     * @return \StructType\Identification
     */
    public function setAuthority($authority = null)
    {
        // validation for constraint: string
        if (!is_null($authority) && !is_string($authority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authority, true), gettype($authority)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($authority) && mb_strlen($authority) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($authority)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($authority) && mb_strlen($authority) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($authority)), __LINE__);
        }
        $this->authority = $authority;
        return $this;
    }
    /**
     * Get identificationInformation value
     * @return string|null
     */
    public function getIdentificationInformation()
    {
        return $this->identificationInformation;
    }
    /**
     * Set identificationInformation value
     * @param string $identificationInformation
     * @return \StructType\Identification
     */
    public function setIdentificationInformation($identificationInformation = null)
    {
        // validation for constraint: string
        if (!is_null($identificationInformation) && !is_string($identificationInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationInformation, true), gettype($identificationInformation)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($identificationInformation) && mb_strlen($identificationInformation) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($identificationInformation)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($identificationInformation) && mb_strlen($identificationInformation) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($identificationInformation)), __LINE__);
        }
        $this->identificationInformation = $identificationInformation;
        return $this;
    }
    /**
     * Get ausstellungsland value
     * @return \StructType\Country|null
     */
    public function getAusstellungsland()
    {
        return $this->ausstellungsland;
    }
    /**
     * Set ausstellungsland value
     * @param \StructType\Country $ausstellungsland
     * @return \StructType\Identification
     */
    public function setAusstellungsland(\StructType\Country $ausstellungsland = null)
    {
        $this->ausstellungsland = $ausstellungsland;
        return $this;
    }
    /**
     * Get dateOfEntry value
     * @return string|null
     */
    public function getDateOfEntry()
    {
        return $this->dateOfEntry;
    }
    /**
     * Set dateOfEntry value
     * @param string $dateOfEntry
     * @return \StructType\Identification
     */
    public function setDateOfEntry($dateOfEntry = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfEntry) && !is_string($dateOfEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfEntry, true), gettype($dateOfEntry)), __LINE__);
        }
        $this->dateOfEntry = $dateOfEntry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Identification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
