<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getVersionResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Liefert die aktuelle Versionsnummer der eVP Online (kann für Testzwecke verwendet werden. z.B. zur Prüfung ob die Webservices Online sind)
 * @subpackage Structs
 */
class GetVersionResponse extends AbstractStructBase
{
    /**
     * The versionNumber
     * Meta information extracted from the WSDL
     * - documentation: Versionsnummer der eVP Online (z.B. 2.36.00 oder 2.36.c1)
     * @var string
     */
    public $versionNumber;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for getVersionResponse
     * @uses GetVersionResponse::setVersionNumber()
     * @uses GetVersionResponse::setEvpServiceFault()
     * @param string $versionNumber
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct($versionNumber = null, \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setVersionNumber($versionNumber)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get versionNumber value
     * @return string|null
     */
    public function getVersionNumber()
    {
        return $this->versionNumber;
    }
    /**
     * Set versionNumber value
     * @param string $versionNumber
     * @return \StructType\GetVersionResponse
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($versionNumber) && !is_string($versionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionNumber, true), gettype($versionNumber)), __LINE__);
        }
        $this->versionNumber = $versionNumber;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\GetVersionResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVersionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
