<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBerechnungswerteRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request einen Contract abzuholen
 * @subpackage Structs
 */
class GetBerechnungswerteRequest extends AbstractStructBase
{
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - documentation: Polizzen Informationen für eine Schadenmeldung
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Policy[]
     */
    public $policy;
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login user
     * @var \StructType\Login
     */
    public $login;
    /**
     * Constructor method for getBerechnungswerteRequest
     * @uses GetBerechnungswerteRequest::setPolicy()
     * @uses GetBerechnungswerteRequest::setLogin()
     * @param \StructType\Policy[] $policy
     * @param \StructType\Login $login
     */
    public function __construct(array $policy = array(), \StructType\Login $login = null)
    {
        $this
            ->setPolicy($policy)
            ->setLogin($login);
    }
    /**
     * Get policy value
     * @return \StructType\Policy[]
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyForArrayConstraintsFromSetPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getBerechnungswerteRequestPolicyItem) {
            // validation for constraint: itemType
            if (!$getBerechnungswerteRequestPolicyItem instanceof \StructType\Policy) {
                $invalidValues[] = is_object($getBerechnungswerteRequestPolicyItem) ? get_class($getBerechnungswerteRequestPolicyItem) : sprintf('%s(%s)', gettype($getBerechnungswerteRequestPolicyItem), var_export($getBerechnungswerteRequestPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The policy property can only contain items of type \StructType\Policy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set policy value
     * @throws \InvalidArgumentException
     * @param \StructType\Policy[] $policy
     * @return \StructType\GetBerechnungswerteRequest
     */
    public function setPolicy(array $policy = array())
    {
        // validation for constraint: array
        if ('' !== ($policyArrayErrorMessage = self::validatePolicyForArrayConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyArrayErrorMessage, __LINE__);
        }
        $this->policy = $policy;
        return $this;
    }
    /**
     * Add item to policy value
     * @throws \InvalidArgumentException
     * @param \StructType\Policy $item
     * @return \StructType\GetBerechnungswerteRequest
     */
    public function addToPolicy(\StructType\Policy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Policy) {
            throw new \InvalidArgumentException(sprintf('The policy property can only contain items of type \StructType\Policy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->policy[] = $item;
        return $this;
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetBerechnungswerteRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBerechnungswerteRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
