<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fahrzeugnutzungType StructType
 * @subpackage Structs
 */
class FahrzeugnutzungType extends AbstractStructBase
{
    /**
     * The nutzung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nutzung;
    /**
     * The kilometerleistung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $kilometerleistung;
    /**
     * The kilometerstand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $kilometerstand;
    /**
     * The fahrzeugbenutzer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fahrzeugbenutzer;
    /**
     * The garage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $garage;
    /**
     * Constructor method for fahrzeugnutzungType
     * @uses FahrzeugnutzungType::setNutzung()
     * @uses FahrzeugnutzungType::setKilometerleistung()
     * @uses FahrzeugnutzungType::setKilometerstand()
     * @uses FahrzeugnutzungType::setFahrzeugbenutzer()
     * @uses FahrzeugnutzungType::setGarage()
     * @param string $nutzung
     * @param int $kilometerleistung
     * @param int $kilometerstand
     * @param string $fahrzeugbenutzer
     * @param string $garage
     */
    public function __construct($nutzung = null, $kilometerleistung = null, $kilometerstand = null, $fahrzeugbenutzer = null, $garage = null)
    {
        $this
            ->setNutzung($nutzung)
            ->setKilometerleistung($kilometerleistung)
            ->setKilometerstand($kilometerstand)
            ->setFahrzeugbenutzer($fahrzeugbenutzer)
            ->setGarage($garage);
    }
    /**
     * Get nutzung value
     * @return string|null
     */
    public function getNutzung()
    {
        return $this->nutzung;
    }
    /**
     * Set nutzung value
     * @uses \EnumType\FahrzeugnutzungsartenType::valueIsValid()
     * @uses \EnumType\FahrzeugnutzungsartenType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nutzung
     * @return \StructType\FahrzeugnutzungType
     */
    public function setNutzung($nutzung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FahrzeugnutzungsartenType::valueIsValid($nutzung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FahrzeugnutzungsartenType', is_array($nutzung) ? implode(', ', $nutzung) : var_export($nutzung, true), implode(', ', \EnumType\FahrzeugnutzungsartenType::getValidValues())), __LINE__);
        }
        $this->nutzung = $nutzung;
        return $this;
    }
    /**
     * Get kilometerleistung value
     * @return int|null
     */
    public function getKilometerleistung()
    {
        return $this->kilometerleistung;
    }
    /**
     * Set kilometerleistung value
     * @param int $kilometerleistung
     * @return \StructType\FahrzeugnutzungType
     */
    public function setKilometerleistung($kilometerleistung = null)
    {
        // validation for constraint: int
        if (!is_null($kilometerleistung) && !(is_int($kilometerleistung) || ctype_digit($kilometerleistung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kilometerleistung, true), gettype($kilometerleistung)), __LINE__);
        }
        $this->kilometerleistung = $kilometerleistung;
        return $this;
    }
    /**
     * Get kilometerstand value
     * @return int|null
     */
    public function getKilometerstand()
    {
        return $this->kilometerstand;
    }
    /**
     * Set kilometerstand value
     * @param int $kilometerstand
     * @return \StructType\FahrzeugnutzungType
     */
    public function setKilometerstand($kilometerstand = null)
    {
        // validation for constraint: int
        if (!is_null($kilometerstand) && !(is_int($kilometerstand) || ctype_digit($kilometerstand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kilometerstand, true), gettype($kilometerstand)), __LINE__);
        }
        $this->kilometerstand = $kilometerstand;
        return $this;
    }
    /**
     * Get fahrzeugbenutzer value
     * @return string|null
     */
    public function getFahrzeugbenutzer()
    {
        return $this->fahrzeugbenutzer;
    }
    /**
     * Set fahrzeugbenutzer value
     * @uses \EnumType\FahrzeugbenutzerType::valueIsValid()
     * @uses \EnumType\FahrzeugbenutzerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fahrzeugbenutzer
     * @return \StructType\FahrzeugnutzungType
     */
    public function setFahrzeugbenutzer($fahrzeugbenutzer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FahrzeugbenutzerType::valueIsValid($fahrzeugbenutzer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FahrzeugbenutzerType', is_array($fahrzeugbenutzer) ? implode(', ', $fahrzeugbenutzer) : var_export($fahrzeugbenutzer, true), implode(', ', \EnumType\FahrzeugbenutzerType::getValidValues())), __LINE__);
        }
        $this->fahrzeugbenutzer = $fahrzeugbenutzer;
        return $this;
    }
    /**
     * Get garage value
     * @return string|null
     */
    public function getGarage()
    {
        return $this->garage;
    }
    /**
     * Set garage value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $garage
     * @return \StructType\FahrzeugnutzungType
     */
    public function setGarage($garage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($garage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($garage) ? implode(', ', $garage) : var_export($garage, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->garage = $garage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FahrzeugnutzungType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
