<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataForPolicy StructType
 * @subpackage Structs
 */
class DataForPolicy extends AbstractStructBase
{
    /**
     * The businessCaseType
     * @var string
     */
    public $businessCaseType;
    /**
     * The externalContractNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalContractNumber;
    /**
     * The businessCaseID
     * Meta information extracted from the WSDL
     * - documentation: If a businessCaseID is given and this businessCase has the same businessCaseType as requested, the businessCase will be overwritten with the new data from this request.
     * - minOccurs: 0
     * @var int
     */
    public $businessCaseID;
    /**
     * The policyData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Consultation_ContractData
     */
    public $policyData;
    /**
     * The attribute
     * Meta information extracted from the WSDL
     * - choice: attribute | generalikfzv2 | generaliprivat
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Attribute[]
     */
    public $attribute;
    /**
     * The generalikfzv2
     * Meta information extracted from the WSDL
     * - choice: attribute | generalikfzv2 | generaliprivat
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Generalikfzv2Type
     */
    public $generalikfzv2;
    /**
     * The generaliprivat
     * Meta information extracted from the WSDL
     * - choice: attribute | generalikfzv2 | generaliprivat
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\GeneraliprivatType
     */
    public $generaliprivat;
    /**
     * The vinkulierungKasko
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VinkularglaeubigerType
     */
    public $vinkulierungKasko;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - documentation: Attachment Objekte
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * The blankoVB
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $blankoVB;
    /**
     * The anmeldungKundenportal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AnmeldungKundenportalType
     */
    public $anmeldungKundenportal;
    /**
     * Constructor method for DataForPolicy
     * @uses DataForPolicy::setBusinessCaseType()
     * @uses DataForPolicy::setExternalContractNumber()
     * @uses DataForPolicy::setBusinessCaseID()
     * @uses DataForPolicy::setPolicyData()
     * @uses DataForPolicy::setAttribute()
     * @uses DataForPolicy::setGeneralikfzv2()
     * @uses DataForPolicy::setGeneraliprivat()
     * @uses DataForPolicy::setVinkulierungKasko()
     * @uses DataForPolicy::setAttachment()
     * @uses DataForPolicy::setBlankoVB()
     * @uses DataForPolicy::setAnmeldungKundenportal()
     * @param string $businessCaseType
     * @param string $externalContractNumber
     * @param int $businessCaseID
     * @param \StructType\Consultation_ContractData $policyData
     * @param \StructType\Attribute[] $attribute
     * @param \StructType\Generalikfzv2Type $generalikfzv2
     * @param \StructType\GeneraliprivatType $generaliprivat
     * @param \StructType\VinkularglaeubigerType $vinkulierungKasko
     * @param \StructType\Attachment[] $attachment
     * @param bool $blankoVB
     * @param \StructType\AnmeldungKundenportalType $anmeldungKundenportal
     */
    public function __construct($businessCaseType = null, $externalContractNumber = null, $businessCaseID = null, \StructType\Consultation_ContractData $policyData = null, array $attribute = array(), \StructType\Generalikfzv2Type $generalikfzv2 = null, \StructType\GeneraliprivatType $generaliprivat = null, \StructType\VinkularglaeubigerType $vinkulierungKasko = null, array $attachment = array(), $blankoVB = null, \StructType\AnmeldungKundenportalType $anmeldungKundenportal = null)
    {
        $this
            ->setBusinessCaseType($businessCaseType)
            ->setExternalContractNumber($externalContractNumber)
            ->setBusinessCaseID($businessCaseID)
            ->setPolicyData($policyData)
            ->setAttribute($attribute)
            ->setGeneralikfzv2($generalikfzv2)
            ->setGeneraliprivat($generaliprivat)
            ->setVinkulierungKasko($vinkulierungKasko)
            ->setAttachment($attachment)
            ->setBlankoVB($blankoVB)
            ->setAnmeldungKundenportal($anmeldungKundenportal);
    }
    /**
     * Get businessCaseType value
     * @return string|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessCaseType
     * @return \StructType\DataForPolicy
     */
    public function setBusinessCaseType($businessCaseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($businessCaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($businessCaseType) ? implode(', ', $businessCaseType) : var_export($businessCaseType, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Get externalContractNumber value
     * @return string|null
     */
    public function getExternalContractNumber()
    {
        return $this->externalContractNumber;
    }
    /**
     * Set externalContractNumber value
     * @param string $externalContractNumber
     * @return \StructType\DataForPolicy
     */
    public function setExternalContractNumber($externalContractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalContractNumber) && !is_string($externalContractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalContractNumber, true), gettype($externalContractNumber)), __LINE__);
        }
        $this->externalContractNumber = $externalContractNumber;
        return $this;
    }
    /**
     * Get businessCaseID value
     * @return int|null
     */
    public function getBusinessCaseID()
    {
        return $this->businessCaseID;
    }
    /**
     * Set businessCaseID value
     * @param int $businessCaseID
     * @return \StructType\DataForPolicy
     */
    public function setBusinessCaseID($businessCaseID = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseID) && !(is_int($businessCaseID) || ctype_digit($businessCaseID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseID, true), gettype($businessCaseID)), __LINE__);
        }
        $this->businessCaseID = $businessCaseID;
        return $this;
    }
    /**
     * Get policyData value
     * @return \StructType\Consultation_ContractData|null
     */
    public function getPolicyData()
    {
        return $this->policyData;
    }
    /**
     * Set policyData value
     * @param \StructType\Consultation_ContractData $policyData
     * @return \StructType\DataForPolicy
     */
    public function setPolicyData(\StructType\Consultation_ContractData $policyData = null)
    {
        $this->policyData = $policyData;
        return $this;
    }
    /**
     * Get attribute value
     * @return \StructType\Attribute[]|null
     */
    public function getAttribute()
    {
        return isset($this->attribute) ? $this->attribute : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dataForPolicyAttributeItem) {
            // validation for constraint: itemType
            if (!$dataForPolicyAttributeItem instanceof \StructType\Attribute) {
                $invalidValues[] = is_object($dataForPolicyAttributeItem) ? get_class($dataForPolicyAttributeItem) : sprintf('%s(%s)', gettype($dataForPolicyAttributeItem), var_export($dataForPolicyAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attribute property can only contain items of type \StructType\Attribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAttributeForChoiceConstraintsFromSetAttribute($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'generalikfzv2',
            'generaliprivat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property attribute can\'t be set as the property %s is already set. Only one property must be set among these properties: attribute, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set attribute value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute[] $attribute
     * @return \StructType\DataForPolicy
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(attribute, generalikfzv2, generaliprivat)
        if ('' !== ($attributeChoiceErrorMessage = self::validateAttributeForChoiceConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeChoiceErrorMessage, __LINE__);
        }
        if (is_null($attribute) || (is_array($attribute) && empty($attribute))) {
            unset($this->attribute);
        } else {
            $this->attribute = $attribute;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToAttribute method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToAttribute($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'generalikfzv2',
            'generaliprivat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property attribute can\'t be set as the property %s is already set. Only one property must be set among these properties: attribute, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute $item
     * @return \StructType\DataForPolicy
     */
    public function addToAttribute(\StructType\Attribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attribute) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of type \StructType\Attribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(attribute, generalikfzv2, generaliprivat)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToAttribute($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
    /**
     * Get generalikfzv2 value
     * @return \StructType\Generalikfzv2Type|null
     */
    public function getGeneralikfzv2()
    {
        return isset($this->generalikfzv2) ? $this->generalikfzv2 : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGeneralikfzv2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneralikfzv2 method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGeneralikfzv2ForChoiceConstraintsFromSetGeneralikfzv2($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'attribute',
            'generaliprivat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property generalikfzv2 can\'t be set as the property %s is already set. Only one property must be set among these properties: generalikfzv2, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set generalikfzv2 value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Generalikfzv2Type $generalikfzv2
     * @return \StructType\DataForPolicy
     */
    public function setGeneralikfzv2(\StructType\Generalikfzv2Type $generalikfzv2 = null)
    {
        // validation for constraint: choice(attribute, generalikfzv2, generaliprivat)
        if ('' !== ($generalikfzv2ChoiceErrorMessage = self::validateGeneralikfzv2ForChoiceConstraintsFromSetGeneralikfzv2($generalikfzv2))) {
            throw new \InvalidArgumentException($generalikfzv2ChoiceErrorMessage, __LINE__);
        }
        if (is_null($generalikfzv2) || (is_array($generalikfzv2) && empty($generalikfzv2))) {
            unset($this->generalikfzv2);
        } else {
            $this->generalikfzv2 = $generalikfzv2;
        }
        return $this;
    }
    /**
     * Get generaliprivat value
     * @return \StructType\GeneraliprivatType|null
     */
    public function getGeneraliprivat()
    {
        return isset($this->generaliprivat) ? $this->generaliprivat : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGeneraliprivat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneraliprivat method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGeneraliprivatForChoiceConstraintsFromSetGeneraliprivat($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'attribute',
            'generalikfzv2',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property generaliprivat can\'t be set as the property %s is already set. Only one property must be set among these properties: generaliprivat, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set generaliprivat value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GeneraliprivatType $generaliprivat
     * @return \StructType\DataForPolicy
     */
    public function setGeneraliprivat(\StructType\GeneraliprivatType $generaliprivat = null)
    {
        // validation for constraint: choice(attribute, generalikfzv2, generaliprivat)
        if ('' !== ($generaliprivatChoiceErrorMessage = self::validateGeneraliprivatForChoiceConstraintsFromSetGeneraliprivat($generaliprivat))) {
            throw new \InvalidArgumentException($generaliprivatChoiceErrorMessage, __LINE__);
        }
        if (is_null($generaliprivat) || (is_array($generaliprivat) && empty($generaliprivat))) {
            unset($this->generaliprivat);
        } else {
            $this->generaliprivat = $generaliprivat;
        }
        return $this;
    }
    /**
     * Get vinkulierungKasko value
     * @return \StructType\VinkularglaeubigerType|null
     */
    public function getVinkulierungKasko()
    {
        return $this->vinkulierungKasko;
    }
    /**
     * Set vinkulierungKasko value
     * @param \StructType\VinkularglaeubigerType $vinkulierungKasko
     * @return \StructType\DataForPolicy
     */
    public function setVinkulierungKasko(\StructType\VinkularglaeubigerType $vinkulierungKasko = null)
    {
        $this->vinkulierungKasko = $vinkulierungKasko;
        return $this;
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dataForPolicyAttachmentItem) {
            // validation for constraint: itemType
            if (!$dataForPolicyAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($dataForPolicyAttachmentItem) ? get_class($dataForPolicyAttachmentItem) : sprintf('%s(%s)', gettype($dataForPolicyAttachmentItem), var_export($dataForPolicyAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\DataForPolicy
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\DataForPolicy
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Get blankoVB value
     * @return bool|null
     */
    public function getBlankoVB()
    {
        return $this->blankoVB;
    }
    /**
     * Set blankoVB value
     * @param bool $blankoVB
     * @return \StructType\DataForPolicy
     */
    public function setBlankoVB($blankoVB = null)
    {
        // validation for constraint: boolean
        if (!is_null($blankoVB) && !is_bool($blankoVB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blankoVB, true), gettype($blankoVB)), __LINE__);
        }
        $this->blankoVB = $blankoVB;
        return $this;
    }
    /**
     * Get anmeldungKundenportal value
     * @return \StructType\AnmeldungKundenportalType|null
     */
    public function getAnmeldungKundenportal()
    {
        return $this->anmeldungKundenportal;
    }
    /**
     * Set anmeldungKundenportal value
     * @param \StructType\AnmeldungKundenportalType $anmeldungKundenportal
     * @return \StructType\DataForPolicy
     */
    public function setAnmeldungKundenportal(\StructType\AnmeldungKundenportalType $anmeldungKundenportal = null)
    {
        $this->anmeldungKundenportal = $anmeldungKundenportal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataForPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
