<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Country StructType
 * Meta information extracted from the WSDL
 * - documentation: Landobjekt
 * @subpackage Structs
 */
class Country extends AbstractStructBase
{
    /**
     * The isoCode
     * Meta information extracted from the WSDL
     * - documentation: 2 stelliger internationaler ISO-Code des Landes
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $isoCode;
    /**
     * Constructor method for Country
     * @uses Country::setIsoCode()
     * @param string $isoCode
     */
    public function __construct($isoCode = null)
    {
        $this
            ->setIsoCode($isoCode);
    }
    /**
     * Get isoCode value
     * @return string|null
     */
    public function getIsoCode()
    {
        return $this->isoCode;
    }
    /**
     * Set isoCode value
     * @param string $isoCode
     * @return \StructType\Country
     */
    public function setIsoCode($isoCode = null)
    {
        // validation for constraint: string
        if (!is_null($isoCode) && !is_string($isoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isoCode, true), gettype($isoCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($isoCode) && mb_strlen($isoCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($isoCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($isoCode) && mb_strlen($isoCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($isoCode)), __LINE__);
        }
        $this->isoCode = $isoCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Country
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
