<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Chat StructType
 * Meta information extracted from the WSDL
 * - documentation: chatconversation IT-Assistance
 * @subpackage Structs
 */
class Chat extends AbstractStructBase
{
    /**
     * The user
     * Meta information extracted from the WSDL
     * - documentation: Either supportemployee or costumer
     * @var string
     */
    public $user;
    /**
     * The datetimeofConversation
     * Meta information extracted from the WSDL
     * - documentation: Date/Time of written text
     * @var string
     */
    public $datetimeofConversation;
    /**
     * The text
     * Meta information extracted from the WSDL
     * - documentation: one part of conversation
     * @var string
     */
    public $text;
    /**
     * Constructor method for Chat
     * @uses Chat::setUser()
     * @uses Chat::setDatetimeofConversation()
     * @uses Chat::setText()
     * @param string $user
     * @param string $datetimeofConversation
     * @param string $text
     */
    public function __construct($user = null, $datetimeofConversation = null, $text = null)
    {
        $this
            ->setUser($user)
            ->setDatetimeofConversation($datetimeofConversation)
            ->setText($text);
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\Chat
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get datetimeofConversation value
     * @return string|null
     */
    public function getDatetimeofConversation()
    {
        return $this->datetimeofConversation;
    }
    /**
     * Set datetimeofConversation value
     * @param string $datetimeofConversation
     * @return \StructType\Chat
     */
    public function setDatetimeofConversation($datetimeofConversation = null)
    {
        // validation for constraint: string
        if (!is_null($datetimeofConversation) && !is_string($datetimeofConversation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datetimeofConversation, true), gettype($datetimeofConversation)), __LINE__);
        }
        $this->datetimeofConversation = $datetimeofConversation;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\Chat
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Chat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
