<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessCase StructType
 * Meta information extracted from the WSDL
 * - documentation: Geschäftsfalldaten
 * @subpackage Structs
 */
class BusinessCase extends AbstractStructBase
{
    /**
     * The businessCaseNumber
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles in der eVP
     * @var int
     */
    public $businessCaseNumber;
    /**
     * The businessCaseNumberAsString
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles als String in der eVP
     * @var string
     */
    public $businessCaseNumberAsString;
    /**
     * The businessCaseNumberTIS
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles der TIS
     * - minOccurs: 0
     * @var int
     */
    public $businessCaseNumberTIS;
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - documentation: Generali-interne ID zum Referenzieren der Geschäftsfälle
     * - base: xsd:string
     * - maxLength: 23
     * @var string
     */
    public $documentID;
    /**
     * The policyNumberOld
     * Meta information extracted from the WSDL
     * - documentation: Polizzennummer eines Vorvertrages bzw. externe Vertragsnummer
     * - minOccurs: 0
     * @var string
     */
    public $policyNumberOld;
    /**
     * The agentNumber
     * Meta information extracted from the WSDL
     * - documentation: Vermittlernummer
     * - minOccurs: 0
     * @var string
     */
    public $agentNumber;
    /**
     * The businessCaseType
     * @var string
     */
    public $businessCaseType;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - documentation: Status des Antrages. Z.B. Angebot gespeichert, Antrag übertragen, Schadenmeldung gespeichert,...
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $state;
    /**
     * The branch
     * Meta information extracted from the WSDL
     * - documentation: Die Geschäftsstelle die in den Antragsdaten der Berechnung eingetragen wurde
     * @var string
     */
    public $branch;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Freie Beschreibung des Versicherungsproduktes
     * @var string
     */
    public $product;
    /**
     * The premium
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsprämie laut paymentFrequenz (Zahlungsweise). Lieferung ist leider nur als String möglich.
     * - minOccurs: 0
     * @var string
     */
    public $premium;
    /**
     * The paymentFrequency
     * @var string
     */
    public $paymentFrequency;
    /**
     * The modifyDate
     * Meta information extracted from the WSDL
     * - documentation: Änderungsdatum des Geschäftsfalles
     * @var string
     */
    public $modifyDate;
    /**
     * The policyDate
     * Meta information extracted from the WSDL
     * - documentation: Datum wann polizziert wurde
     * - minOccurs: 0
     * @var string
     */
    public $policyDate;
    /**
     * The cancelDate
     * Meta information extracted from the WSDL
     * - documentation: Datum wann storniert wurde (in Österreich nicht implementiert)
     * - minOccurs: 0
     * @var string
     */
    public $cancelDate;
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - documentation: Ist die UserID dem der Geschäftsfall zugeordnet ist (Muss nicht der User sein der den GF zuletzt bearbeitet hat)
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $userID;
    /**
     * The insuranceHolder
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsnehmer des GF
     * @var \StructType\BusinessCaseInsuranceHolder
     */
    public $insuranceHolder;
    /**
     * The printDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PrintDocument[]
     */
    public $printDocument;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - documentation: Die Attachement-Files die zum GF angelegt wurden
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * The frameAgreement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FrameAgreement[]
     */
    public $frameAgreement;
    /**
     * The consultationProtocoll
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConsultationProtocoll
     */
    public $consultationProtocoll;
    /**
     * The history
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\History[]
     */
    public $history;
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - documentation: Kunden-ID des zugehörigen Versicherungsnehmers
     * - minOccurs: 0
     * @var int
     */
    public $customerID;
    /**
     * The foreignID
     * Meta information extracted from the WSDL
     * - documentation: Externe Nummer (Schaden-/Antragsnummer) für Zugehörigkeit mit Fremdsystemen
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $foreignID;
    /**
     * The licencePlate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licencePlate;
    /**
     * The readonlyLink
     * Meta information extracted from the WSDL
     * - documentation: Link auf die Readonly des Geschäftsfalles
     * @var string
     */
    public $readonlyLink;
    /**
     * The temporarySaved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $temporarySaved;
    /**
     * The saveData
     * Meta information extracted from the WSDL
     * - documentation: XML-Datenblob
     * - minOccurs: 0
     * @var string
     */
    public $saveData;
    /**
     * Constructor method for BusinessCase
     * @uses BusinessCase::setBusinessCaseNumber()
     * @uses BusinessCase::setBusinessCaseNumberAsString()
     * @uses BusinessCase::setBusinessCaseNumberTIS()
     * @uses BusinessCase::setDocumentID()
     * @uses BusinessCase::setPolicyNumberOld()
     * @uses BusinessCase::setAgentNumber()
     * @uses BusinessCase::setBusinessCaseType()
     * @uses BusinessCase::setState()
     * @uses BusinessCase::setBranch()
     * @uses BusinessCase::setProduct()
     * @uses BusinessCase::setPremium()
     * @uses BusinessCase::setPaymentFrequency()
     * @uses BusinessCase::setModifyDate()
     * @uses BusinessCase::setPolicyDate()
     * @uses BusinessCase::setCancelDate()
     * @uses BusinessCase::setUserID()
     * @uses BusinessCase::setInsuranceHolder()
     * @uses BusinessCase::setPrintDocument()
     * @uses BusinessCase::setAttachment()
     * @uses BusinessCase::setFrameAgreement()
     * @uses BusinessCase::setConsultationProtocoll()
     * @uses BusinessCase::setHistory()
     * @uses BusinessCase::setCustomerID()
     * @uses BusinessCase::setForeignID()
     * @uses BusinessCase::setLicencePlate()
     * @uses BusinessCase::setReadonlyLink()
     * @uses BusinessCase::setTemporarySaved()
     * @uses BusinessCase::setSaveData()
     * @param int $businessCaseNumber
     * @param string $businessCaseNumberAsString
     * @param int $businessCaseNumberTIS
     * @param string $documentID
     * @param string $policyNumberOld
     * @param string $agentNumber
     * @param string $businessCaseType
     * @param string $state
     * @param string $branch
     * @param string $product
     * @param string $premium
     * @param string $paymentFrequency
     * @param string $modifyDate
     * @param string $policyDate
     * @param string $cancelDate
     * @param string $userID
     * @param \StructType\BusinessCaseInsuranceHolder $insuranceHolder
     * @param \StructType\PrintDocument[] $printDocument
     * @param \StructType\Attachment[] $attachment
     * @param \StructType\FrameAgreement[] $frameAgreement
     * @param \StructType\ConsultationProtocoll $consultationProtocoll
     * @param \StructType\History[] $history
     * @param int $customerID
     * @param string $foreignID
     * @param string $licencePlate
     * @param string $readonlyLink
     * @param bool $temporarySaved
     * @param string $saveData
     */
    public function __construct($businessCaseNumber = null, $businessCaseNumberAsString = null, $businessCaseNumberTIS = null, $documentID = null, $policyNumberOld = null, $agentNumber = null, $businessCaseType = null, $state = null, $branch = null, $product = null, $premium = null, $paymentFrequency = null, $modifyDate = null, $policyDate = null, $cancelDate = null, $userID = null, \StructType\BusinessCaseInsuranceHolder $insuranceHolder = null, array $printDocument = array(), array $attachment = array(), array $frameAgreement = array(), \StructType\ConsultationProtocoll $consultationProtocoll = null, array $history = array(), $customerID = null, $foreignID = null, $licencePlate = null, $readonlyLink = null, $temporarySaved = null, $saveData = null)
    {
        $this
            ->setBusinessCaseNumber($businessCaseNumber)
            ->setBusinessCaseNumberAsString($businessCaseNumberAsString)
            ->setBusinessCaseNumberTIS($businessCaseNumberTIS)
            ->setDocumentID($documentID)
            ->setPolicyNumberOld($policyNumberOld)
            ->setAgentNumber($agentNumber)
            ->setBusinessCaseType($businessCaseType)
            ->setState($state)
            ->setBranch($branch)
            ->setProduct($product)
            ->setPremium($premium)
            ->setPaymentFrequency($paymentFrequency)
            ->setModifyDate($modifyDate)
            ->setPolicyDate($policyDate)
            ->setCancelDate($cancelDate)
            ->setUserID($userID)
            ->setInsuranceHolder($insuranceHolder)
            ->setPrintDocument($printDocument)
            ->setAttachment($attachment)
            ->setFrameAgreement($frameAgreement)
            ->setConsultationProtocoll($consultationProtocoll)
            ->setHistory($history)
            ->setCustomerID($customerID)
            ->setForeignID($foreignID)
            ->setLicencePlate($licencePlate)
            ->setReadonlyLink($readonlyLink)
            ->setTemporarySaved($temporarySaved)
            ->setSaveData($saveData);
    }
    /**
     * Get businessCaseNumber value
     * @return int|null
     */
    public function getBusinessCaseNumber()
    {
        return $this->businessCaseNumber;
    }
    /**
     * Set businessCaseNumber value
     * @param int $businessCaseNumber
     * @return \StructType\BusinessCase
     */
    public function setBusinessCaseNumber($businessCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseNumber) && !(is_int($businessCaseNumber) || ctype_digit($businessCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseNumber, true), gettype($businessCaseNumber)), __LINE__);
        }
        $this->businessCaseNumber = $businessCaseNumber;
        return $this;
    }
    /**
     * Get businessCaseNumberAsString value
     * @return string|null
     */
    public function getBusinessCaseNumberAsString()
    {
        return $this->businessCaseNumberAsString;
    }
    /**
     * Set businessCaseNumberAsString value
     * @param string $businessCaseNumberAsString
     * @return \StructType\BusinessCase
     */
    public function setBusinessCaseNumberAsString($businessCaseNumberAsString = null)
    {
        // validation for constraint: string
        if (!is_null($businessCaseNumberAsString) && !is_string($businessCaseNumberAsString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessCaseNumberAsString, true), gettype($businessCaseNumberAsString)), __LINE__);
        }
        $this->businessCaseNumberAsString = $businessCaseNumberAsString;
        return $this;
    }
    /**
     * Get businessCaseNumberTIS value
     * @return int|null
     */
    public function getBusinessCaseNumberTIS()
    {
        return $this->businessCaseNumberTIS;
    }
    /**
     * Set businessCaseNumberTIS value
     * @param int $businessCaseNumberTIS
     * @return \StructType\BusinessCase
     */
    public function setBusinessCaseNumberTIS($businessCaseNumberTIS = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseNumberTIS) && !(is_int($businessCaseNumberTIS) || ctype_digit($businessCaseNumberTIS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseNumberTIS, true), gettype($businessCaseNumberTIS)), __LINE__);
        }
        $this->businessCaseNumberTIS = $businessCaseNumberTIS;
        return $this;
    }
    /**
     * Get documentID value
     * @return string|null
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param string $documentID
     * @return \StructType\BusinessCase
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: string
        if (!is_null($documentID) && !is_string($documentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        // validation for constraint: maxLength(23)
        if (!is_null($documentID) && mb_strlen($documentID) > 23) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 23', mb_strlen($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get policyNumberOld value
     * @return string|null
     */
    public function getPolicyNumberOld()
    {
        return $this->policyNumberOld;
    }
    /**
     * Set policyNumberOld value
     * @param string $policyNumberOld
     * @return \StructType\BusinessCase
     */
    public function setPolicyNumberOld($policyNumberOld = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumberOld) && !is_string($policyNumberOld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumberOld, true), gettype($policyNumberOld)), __LINE__);
        }
        $this->policyNumberOld = $policyNumberOld;
        return $this;
    }
    /**
     * Get agentNumber value
     * @return string|null
     */
    public function getAgentNumber()
    {
        return $this->agentNumber;
    }
    /**
     * Set agentNumber value
     * @param string $agentNumber
     * @return \StructType\BusinessCase
     */
    public function setAgentNumber($agentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($agentNumber) && !is_string($agentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentNumber, true), gettype($agentNumber)), __LINE__);
        }
        $this->agentNumber = $agentNumber;
        return $this;
    }
    /**
     * Get businessCaseType value
     * @return string|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessCaseType
     * @return \StructType\BusinessCase
     */
    public function setBusinessCaseType($businessCaseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($businessCaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($businessCaseType) ? implode(', ', $businessCaseType) : var_export($businessCaseType, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\BusinessCase
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($state) && mb_strlen($state) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get branch value
     * @return string|null
     */
    public function getBranch()
    {
        return $this->branch;
    }
    /**
     * Set branch value
     * @param string $branch
     * @return \StructType\BusinessCase
     */
    public function setBranch($branch = null)
    {
        // validation for constraint: string
        if (!is_null($branch) && !is_string($branch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branch, true), gettype($branch)), __LINE__);
        }
        $this->branch = $branch;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\BusinessCase
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get premium value
     * @return string|null
     */
    public function getPremium()
    {
        return $this->premium;
    }
    /**
     * Set premium value
     * @param string $premium
     * @return \StructType\BusinessCase
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: string
        if (!is_null($premium) && !is_string($premium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->premium = $premium;
        return $this;
    }
    /**
     * Get paymentFrequency value
     * @return string|null
     */
    public function getPaymentFrequency()
    {
        return $this->paymentFrequency;
    }
    /**
     * Set paymentFrequency value
     * @uses \EnumType\PaymentFrequency::valueIsValid()
     * @uses \EnumType\PaymentFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentFrequency
     * @return \StructType\BusinessCase
     */
    public function setPaymentFrequency($paymentFrequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentFrequency::valueIsValid($paymentFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentFrequency', is_array($paymentFrequency) ? implode(', ', $paymentFrequency) : var_export($paymentFrequency, true), implode(', ', \EnumType\PaymentFrequency::getValidValues())), __LINE__);
        }
        $this->paymentFrequency = $paymentFrequency;
        return $this;
    }
    /**
     * Get modifyDate value
     * @return string|null
     */
    public function getModifyDate()
    {
        return $this->modifyDate;
    }
    /**
     * Set modifyDate value
     * @param string $modifyDate
     * @return \StructType\BusinessCase
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyDate, true), gettype($modifyDate)), __LINE__);
        }
        $this->modifyDate = $modifyDate;
        return $this;
    }
    /**
     * Get policyDate value
     * @return string|null
     */
    public function getPolicyDate()
    {
        return $this->policyDate;
    }
    /**
     * Set policyDate value
     * @param string $policyDate
     * @return \StructType\BusinessCase
     */
    public function setPolicyDate($policyDate = null)
    {
        // validation for constraint: string
        if (!is_null($policyDate) && !is_string($policyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyDate, true), gettype($policyDate)), __LINE__);
        }
        $this->policyDate = $policyDate;
        return $this;
    }
    /**
     * Get cancelDate value
     * @return string|null
     */
    public function getCancelDate()
    {
        return $this->cancelDate;
    }
    /**
     * Set cancelDate value
     * @param string $cancelDate
     * @return \StructType\BusinessCase
     */
    public function setCancelDate($cancelDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelDate) && !is_string($cancelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelDate, true), gettype($cancelDate)), __LINE__);
        }
        $this->cancelDate = $cancelDate;
        return $this;
    }
    /**
     * Get userID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param string $userID
     * @return \StructType\BusinessCase
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($userID) && mb_strlen($userID) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get insuranceHolder value
     * @return \StructType\BusinessCaseInsuranceHolder|null
     */
    public function getInsuranceHolder()
    {
        return $this->insuranceHolder;
    }
    /**
     * Set insuranceHolder value
     * @param \StructType\BusinessCaseInsuranceHolder $insuranceHolder
     * @return \StructType\BusinessCase
     */
    public function setInsuranceHolder(\StructType\BusinessCaseInsuranceHolder $insuranceHolder = null)
    {
        $this->insuranceHolder = $insuranceHolder;
        return $this;
    }
    /**
     * Get printDocument value
     * @return \StructType\PrintDocument[]|null
     */
    public function getPrintDocument()
    {
        return $this->printDocument;
    }
    /**
     * This method is responsible for validating the values passed to the setPrintDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrintDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrintDocumentForArrayConstraintsFromSetPrintDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessCasePrintDocumentItem) {
            // validation for constraint: itemType
            if (!$businessCasePrintDocumentItem instanceof \StructType\PrintDocument) {
                $invalidValues[] = is_object($businessCasePrintDocumentItem) ? get_class($businessCasePrintDocumentItem) : sprintf('%s(%s)', gettype($businessCasePrintDocumentItem), var_export($businessCasePrintDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The printDocument property can only contain items of type \StructType\PrintDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set printDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\PrintDocument[] $printDocument
     * @return \StructType\BusinessCase
     */
    public function setPrintDocument(array $printDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($printDocumentArrayErrorMessage = self::validatePrintDocumentForArrayConstraintsFromSetPrintDocument($printDocument))) {
            throw new \InvalidArgumentException($printDocumentArrayErrorMessage, __LINE__);
        }
        $this->printDocument = $printDocument;
        return $this;
    }
    /**
     * Add item to printDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\PrintDocument $item
     * @return \StructType\BusinessCase
     */
    public function addToPrintDocument(\StructType\PrintDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PrintDocument) {
            throw new \InvalidArgumentException(sprintf('The printDocument property can only contain items of type \StructType\PrintDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->printDocument[] = $item;
        return $this;
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessCaseAttachmentItem) {
            // validation for constraint: itemType
            if (!$businessCaseAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($businessCaseAttachmentItem) ? get_class($businessCaseAttachmentItem) : sprintf('%s(%s)', gettype($businessCaseAttachmentItem), var_export($businessCaseAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\BusinessCase
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\BusinessCase
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Get frameAgreement value
     * @return \StructType\FrameAgreement[]|null
     */
    public function getFrameAgreement()
    {
        return $this->frameAgreement;
    }
    /**
     * This method is responsible for validating the values passed to the setFrameAgreement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFrameAgreement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFrameAgreementForArrayConstraintsFromSetFrameAgreement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessCaseFrameAgreementItem) {
            // validation for constraint: itemType
            if (!$businessCaseFrameAgreementItem instanceof \StructType\FrameAgreement) {
                $invalidValues[] = is_object($businessCaseFrameAgreementItem) ? get_class($businessCaseFrameAgreementItem) : sprintf('%s(%s)', gettype($businessCaseFrameAgreementItem), var_export($businessCaseFrameAgreementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The frameAgreement property can only contain items of type \StructType\FrameAgreement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set frameAgreement value
     * @throws \InvalidArgumentException
     * @param \StructType\FrameAgreement[] $frameAgreement
     * @return \StructType\BusinessCase
     */
    public function setFrameAgreement(array $frameAgreement = array())
    {
        // validation for constraint: array
        if ('' !== ($frameAgreementArrayErrorMessage = self::validateFrameAgreementForArrayConstraintsFromSetFrameAgreement($frameAgreement))) {
            throw new \InvalidArgumentException($frameAgreementArrayErrorMessage, __LINE__);
        }
        $this->frameAgreement = $frameAgreement;
        return $this;
    }
    /**
     * Add item to frameAgreement value
     * @throws \InvalidArgumentException
     * @param \StructType\FrameAgreement $item
     * @return \StructType\BusinessCase
     */
    public function addToFrameAgreement(\StructType\FrameAgreement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FrameAgreement) {
            throw new \InvalidArgumentException(sprintf('The frameAgreement property can only contain items of type \StructType\FrameAgreement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->frameAgreement[] = $item;
        return $this;
    }
    /**
     * Get consultationProtocoll value
     * @return \StructType\ConsultationProtocoll|null
     */
    public function getConsultationProtocoll()
    {
        return $this->consultationProtocoll;
    }
    /**
     * Set consultationProtocoll value
     * @param \StructType\ConsultationProtocoll $consultationProtocoll
     * @return \StructType\BusinessCase
     */
    public function setConsultationProtocoll(\StructType\ConsultationProtocoll $consultationProtocoll = null)
    {
        $this->consultationProtocoll = $consultationProtocoll;
        return $this;
    }
    /**
     * Get history value
     * @return \StructType\History[]|null
     */
    public function getHistory()
    {
        return $this->history;
    }
    /**
     * This method is responsible for validating the values passed to the setHistory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHistory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHistoryForArrayConstraintsFromSetHistory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessCaseHistoryItem) {
            // validation for constraint: itemType
            if (!$businessCaseHistoryItem instanceof \StructType\History) {
                $invalidValues[] = is_object($businessCaseHistoryItem) ? get_class($businessCaseHistoryItem) : sprintf('%s(%s)', gettype($businessCaseHistoryItem), var_export($businessCaseHistoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The history property can only contain items of type \StructType\History, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set history value
     * @throws \InvalidArgumentException
     * @param \StructType\History[] $history
     * @return \StructType\BusinessCase
     */
    public function setHistory(array $history = array())
    {
        // validation for constraint: array
        if ('' !== ($historyArrayErrorMessage = self::validateHistoryForArrayConstraintsFromSetHistory($history))) {
            throw new \InvalidArgumentException($historyArrayErrorMessage, __LINE__);
        }
        $this->history = $history;
        return $this;
    }
    /**
     * Add item to history value
     * @throws \InvalidArgumentException
     * @param \StructType\History $item
     * @return \StructType\BusinessCase
     */
    public function addToHistory(\StructType\History $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\History) {
            throw new \InvalidArgumentException(sprintf('The history property can only contain items of type \StructType\History, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->history[] = $item;
        return $this;
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \StructType\BusinessCase
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
    /**
     * Get foreignID value
     * @return string|null
     */
    public function getForeignID()
    {
        return $this->foreignID;
    }
    /**
     * Set foreignID value
     * @param string $foreignID
     * @return \StructType\BusinessCase
     */
    public function setForeignID($foreignID = null)
    {
        // validation for constraint: string
        if (!is_null($foreignID) && !is_string($foreignID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignID, true), gettype($foreignID)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($foreignID) && mb_strlen($foreignID) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($foreignID)), __LINE__);
        }
        $this->foreignID = $foreignID;
        return $this;
    }
    /**
     * Get licencePlate value
     * @return string|null
     */
    public function getLicencePlate()
    {
        return $this->licencePlate;
    }
    /**
     * Set licencePlate value
     * @param string $licencePlate
     * @return \StructType\BusinessCase
     */
    public function setLicencePlate($licencePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licencePlate) && !is_string($licencePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licencePlate, true), gettype($licencePlate)), __LINE__);
        }
        $this->licencePlate = $licencePlate;
        return $this;
    }
    /**
     * Get readonlyLink value
     * @return string|null
     */
    public function getReadonlyLink()
    {
        return $this->readonlyLink;
    }
    /**
     * Set readonlyLink value
     * @param string $readonlyLink
     * @return \StructType\BusinessCase
     */
    public function setReadonlyLink($readonlyLink = null)
    {
        // validation for constraint: string
        if (!is_null($readonlyLink) && !is_string($readonlyLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readonlyLink, true), gettype($readonlyLink)), __LINE__);
        }
        $this->readonlyLink = $readonlyLink;
        return $this;
    }
    /**
     * Get temporarySaved value
     * @return bool|null
     */
    public function getTemporarySaved()
    {
        return $this->temporarySaved;
    }
    /**
     * Set temporarySaved value
     * @param bool $temporarySaved
     * @return \StructType\BusinessCase
     */
    public function setTemporarySaved($temporarySaved = null)
    {
        // validation for constraint: boolean
        if (!is_null($temporarySaved) && !is_bool($temporarySaved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($temporarySaved, true), gettype($temporarySaved)), __LINE__);
        }
        $this->temporarySaved = $temporarySaved;
        return $this;
    }
    /**
     * Get saveData value
     * @return string|null
     */
    public function getSaveData()
    {
        return $this->saveData;
    }
    /**
     * Set saveData value
     * @param string $saveData
     * @return \StructType\BusinessCase
     */
    public function setSaveData($saveData = null)
    {
        // validation for constraint: string
        if (!is_null($saveData) && !is_string($saveData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saveData, true), gettype($saveData)), __LINE__);
        }
        $this->saveData = $saveData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessCase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
