<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment StructType
 * Meta information extracted from the WSDL
 * - documentation: Attachments die optional an den GF angehängt worden sind
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The businessCaseNumber
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles in der eVP
     * - minOccurs: 0
     * @var int
     */
    public $businessCaseNumber;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: eindeutige id des Attachments
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The fileType
     * Meta information extracted from the WSDL
     * - documentation: MIME-Type des Files im Anhang. Typen : tif,pdf,rtf,doc,docx,txt,html,jpg,xls,xlsx
     * @var string
     */
    public $fileType;
    /**
     * The fileName
     * Meta information extracted from the WSDL
     * - documentation: Dateiname ohne Pfad inkl. Extension
     * - base: xsd:string
     * - maxLength: 100
     * @var string
     */
    public $fileName;
    /**
     * The fileData
     * Meta information extracted from the WSDL
     * - documentation: Beinhaltet den Stream des angehängten Files
     * - minOccurs: 0
     * @var string
     */
    public $fileData;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Sonstige Beschreibung des Attachements | Freie Beschreibung des Geschäftsfalles | Beschreibung des Status
     * - base: xsd:string
     * - maxLength: 200
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The typVorlage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $typVorlage;
    /**
     * Constructor method for Attachment
     * @uses Attachment::setBusinessCaseNumber()
     * @uses Attachment::setId()
     * @uses Attachment::setFileType()
     * @uses Attachment::setFileName()
     * @uses Attachment::setFileData()
     * @uses Attachment::setDescription()
     * @uses Attachment::setTypVorlage()
     * @param int $businessCaseNumber
     * @param int $id
     * @param string $fileType
     * @param string $fileName
     * @param string $fileData
     * @param string $description
     * @param string $typVorlage
     */
    public function __construct($businessCaseNumber = null, $id = null, $fileType = null, $fileName = null, $fileData = null, $description = null, $typVorlage = null)
    {
        $this
            ->setBusinessCaseNumber($businessCaseNumber)
            ->setId($id)
            ->setFileType($fileType)
            ->setFileName($fileName)
            ->setFileData($fileData)
            ->setDescription($description)
            ->setTypVorlage($typVorlage);
    }
    /**
     * Get businessCaseNumber value
     * @return int|null
     */
    public function getBusinessCaseNumber()
    {
        return $this->businessCaseNumber;
    }
    /**
     * Set businessCaseNumber value
     * @param int $businessCaseNumber
     * @return \StructType\Attachment
     */
    public function setBusinessCaseNumber($businessCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseNumber) && !(is_int($businessCaseNumber) || ctype_digit($businessCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseNumber, true), gettype($businessCaseNumber)), __LINE__);
        }
        $this->businessCaseNumber = $businessCaseNumber;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Attachment
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get fileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->fileType;
    }
    /**
     * Set fileType value
     * @param string $fileType
     * @return \StructType\Attachment
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileType, true), gettype($fileType)), __LINE__);
        }
        $this->fileType = $fileType;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\Attachment
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($fileName) && mb_strlen($fileName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get fileData value
     * @return string|null
     */
    public function getFileData()
    {
        return $this->fileData;
    }
    /**
     * Set fileData value
     * @param string $fileData
     * @return \StructType\Attachment
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileData, true), gettype($fileData)), __LINE__);
        }
        $this->fileData = $fileData;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Attachment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($description) && mb_strlen($description) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get typVorlage value
     * @return string|null
     */
    public function getTypVorlage()
    {
        return $this->typVorlage;
    }
    /**
     * Set typVorlage value
     * @uses \EnumType\TypVorlage::valueIsValid()
     * @uses \EnumType\TypVorlage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typVorlage
     * @return \StructType\Attachment
     */
    public function setTypVorlage($typVorlage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypVorlage::valueIsValid($typVorlage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypVorlage', is_array($typVorlage) ? implode(', ', $typVorlage) : var_export($typVorlage, true), implode(', ', \EnumType\TypVorlage::getValidValues())), __LINE__);
        }
        $this->typVorlage = $typVorlage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
