<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArcImageInfo StructType
 * @subpackage Structs
 */
class ArcImageInfo extends AbstractStructBase
{
    /**
     * The arcImageId
     * @var string
     */
    public $arcImageId;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for ArcImageInfo
     * @uses ArcImageInfo::setArcImageId()
     * @uses ArcImageInfo::setName()
     * @uses ArcImageInfo::setType()
     * @param string $arcImageId
     * @param string $name
     * @param string $type
     */
    public function __construct($arcImageId = null, $name = null, $type = null)
    {
        $this
            ->setArcImageId($arcImageId)
            ->setName($name)
            ->setType($type);
    }
    /**
     * Get arcImageId value
     * @return string|null
     */
    public function getArcImageId()
    {
        return $this->arcImageId;
    }
    /**
     * Set arcImageId value
     * @param string $arcImageId
     * @return \StructType\ArcImageInfo
     */
    public function setArcImageId($arcImageId = null)
    {
        // validation for constraint: string
        if (!is_null($arcImageId) && !is_string($arcImageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arcImageId, true), gettype($arcImageId)), __LINE__);
        }
        $this->arcImageId = $arcImageId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ArcImageInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\ArcImageInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArcImageInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
