<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArcContent StructType
 * @subpackage Structs
 */
class ArcContent extends AbstractStructBase
{
    /**
     * The arcContentLength
     * @var int
     */
    public $arcContentLength;
    /**
     * The arcContentType
     * @var string
     */
    public $arcContentType;
    /**
     * The arcImage
     * @var string
     */
    public $arcImage;
    /**
     * Constructor method for ArcContent
     * @uses ArcContent::setArcContentLength()
     * @uses ArcContent::setArcContentType()
     * @uses ArcContent::setArcImage()
     * @param int $arcContentLength
     * @param string $arcContentType
     * @param string $arcImage
     */
    public function __construct($arcContentLength = null, $arcContentType = null, $arcImage = null)
    {
        $this
            ->setArcContentLength($arcContentLength)
            ->setArcContentType($arcContentType)
            ->setArcImage($arcImage);
    }
    /**
     * Get arcContentLength value
     * @return int|null
     */
    public function getArcContentLength()
    {
        return $this->arcContentLength;
    }
    /**
     * Set arcContentLength value
     * @param int $arcContentLength
     * @return \StructType\ArcContent
     */
    public function setArcContentLength($arcContentLength = null)
    {
        // validation for constraint: int
        if (!is_null($arcContentLength) && !(is_int($arcContentLength) || ctype_digit($arcContentLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($arcContentLength, true), gettype($arcContentLength)), __LINE__);
        }
        $this->arcContentLength = $arcContentLength;
        return $this;
    }
    /**
     * Get arcContentType value
     * @return string|null
     */
    public function getArcContentType()
    {
        return $this->arcContentType;
    }
    /**
     * Set arcContentType value
     * @param string $arcContentType
     * @return \StructType\ArcContent
     */
    public function setArcContentType($arcContentType = null)
    {
        // validation for constraint: string
        if (!is_null($arcContentType) && !is_string($arcContentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arcContentType, true), gettype($arcContentType)), __LINE__);
        }
        $this->arcContentType = $arcContentType;
        return $this;
    }
    /**
     * Get arcImage value
     * @return string|null
     */
    public function getArcImage()
    {
        return $this->arcImage;
    }
    /**
     * Set arcImage value
     * @param string $arcImage
     * @return \StructType\ArcContent
     */
    public function setArcImage($arcImage = null)
    {
        // validation for constraint: string
        if (!is_null($arcImage) && !is_string($arcImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arcImage, true), gettype($arcImage)), __LINE__);
        }
        $this->arcImage = $arcImage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArcContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
