<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Advisor StructType
 * Meta information extracted from the WSDL
 * - documentation: Betreuer
 * @subpackage Structs
 */
class Advisor extends AbstractStructBase
{
    /**
     * The advisor
     * Meta information extracted from the WSDL
     * - documentation: ID des Betreuers falls nicht neutrale Betreuung
     * @var string
     */
    public $advisor;
    /**
     * The advisorType
     * Meta information extracted from the WSDL
     * - documentation: Type der Betreuung / Angestellter, Konzern oder DVAG
     * @var string
     */
    public $advisorType;
    /**
     * The advisorEmail
     * Meta information extracted from the WSDL
     * - documentation: eMail des Betreuers falls vorhanden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $advisorEmail;
    /**
     * The advisorTelephon
     * Meta information extracted from the WSDL
     * - documentation: Telefon des Betreuers falls vorhanden
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $advisorTelephon;
    /**
     * The advisorAdress
     * Meta information extracted from the WSDL
     * - documentation: Adresse des Betreuers falls vorhanden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $advisorAdress;
    /**
     * The advisorAdressLat
     * Meta information extracted from the WSDL
     * - documentation: Adresse des Betreuers falls vorhanden, lat
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $advisorAdressLat;
    /**
     * The advisorAdressLng
     * Meta information extracted from the WSDL
     * - documentation: Adresse des Betreuers falls vorhanden, lng
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $advisorAdressLng;
    /**
     * Constructor method for Advisor
     * @uses Advisor::setAdvisor()
     * @uses Advisor::setAdvisorType()
     * @uses Advisor::setAdvisorEmail()
     * @uses Advisor::setAdvisorTelephon()
     * @uses Advisor::setAdvisorAdress()
     * @uses Advisor::setAdvisorAdressLat()
     * @uses Advisor::setAdvisorAdressLng()
     * @param string $advisor
     * @param string $advisorType
     * @param string $advisorEmail
     * @param string[] $advisorTelephon
     * @param string $advisorAdress
     * @param float $advisorAdressLat
     * @param float $advisorAdressLng
     */
    public function __construct($advisor = null, $advisorType = null, $advisorEmail = null, array $advisorTelephon = array(), $advisorAdress = null, $advisorAdressLat = null, $advisorAdressLng = null)
    {
        $this
            ->setAdvisor($advisor)
            ->setAdvisorType($advisorType)
            ->setAdvisorEmail($advisorEmail)
            ->setAdvisorTelephon($advisorTelephon)
            ->setAdvisorAdress($advisorAdress)
            ->setAdvisorAdressLat($advisorAdressLat)
            ->setAdvisorAdressLng($advisorAdressLng);
    }
    /**
     * Get advisor value
     * @return string|null
     */
    public function getAdvisor()
    {
        return $this->advisor;
    }
    /**
     * Set advisor value
     * @param string $advisor
     * @return \StructType\Advisor
     */
    public function setAdvisor($advisor = null)
    {
        // validation for constraint: string
        if (!is_null($advisor) && !is_string($advisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advisor, true), gettype($advisor)), __LINE__);
        }
        $this->advisor = $advisor;
        return $this;
    }
    /**
     * Get advisorType value
     * @return string|null
     */
    public function getAdvisorType()
    {
        return $this->advisorType;
    }
    /**
     * Set advisorType value
     * @uses \EnumType\AdvisorType::valueIsValid()
     * @uses \EnumType\AdvisorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $advisorType
     * @return \StructType\Advisor
     */
    public function setAdvisorType($advisorType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdvisorType::valueIsValid($advisorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdvisorType', is_array($advisorType) ? implode(', ', $advisorType) : var_export($advisorType, true), implode(', ', \EnumType\AdvisorType::getValidValues())), __LINE__);
        }
        $this->advisorType = $advisorType;
        return $this;
    }
    /**
     * Get advisorEmail value
     * @return string|null
     */
    public function getAdvisorEmail()
    {
        return $this->advisorEmail;
    }
    /**
     * Set advisorEmail value
     * @param string $advisorEmail
     * @return \StructType\Advisor
     */
    public function setAdvisorEmail($advisorEmail = null)
    {
        // validation for constraint: string
        if (!is_null($advisorEmail) && !is_string($advisorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advisorEmail, true), gettype($advisorEmail)), __LINE__);
        }
        $this->advisorEmail = $advisorEmail;
        return $this;
    }
    /**
     * Get advisorTelephon value
     * @return string[]|null
     */
    public function getAdvisorTelephon()
    {
        return $this->advisorTelephon;
    }
    /**
     * This method is responsible for validating the values passed to the setAdvisorTelephon method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdvisorTelephon method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdvisorTelephonForArrayConstraintsFromSetAdvisorTelephon(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advisorAdvisorTelephonItem) {
            // validation for constraint: itemType
            if (!is_string($advisorAdvisorTelephonItem)) {
                $invalidValues[] = is_object($advisorAdvisorTelephonItem) ? get_class($advisorAdvisorTelephonItem) : sprintf('%s(%s)', gettype($advisorAdvisorTelephonItem), var_export($advisorAdvisorTelephonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The advisorTelephon property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set advisorTelephon value
     * @throws \InvalidArgumentException
     * @param string[] $advisorTelephon
     * @return \StructType\Advisor
     */
    public function setAdvisorTelephon(array $advisorTelephon = array())
    {
        // validation for constraint: array
        if ('' !== ($advisorTelephonArrayErrorMessage = self::validateAdvisorTelephonForArrayConstraintsFromSetAdvisorTelephon($advisorTelephon))) {
            throw new \InvalidArgumentException($advisorTelephonArrayErrorMessage, __LINE__);
        }
        $this->advisorTelephon = $advisorTelephon;
        return $this;
    }
    /**
     * Add item to advisorTelephon value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Advisor
     */
    public function addToAdvisorTelephon($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The advisorTelephon property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->advisorTelephon[] = $item;
        return $this;
    }
    /**
     * Get advisorAdress value
     * @return string|null
     */
    public function getAdvisorAdress()
    {
        return $this->advisorAdress;
    }
    /**
     * Set advisorAdress value
     * @param string $advisorAdress
     * @return \StructType\Advisor
     */
    public function setAdvisorAdress($advisorAdress = null)
    {
        // validation for constraint: string
        if (!is_null($advisorAdress) && !is_string($advisorAdress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advisorAdress, true), gettype($advisorAdress)), __LINE__);
        }
        $this->advisorAdress = $advisorAdress;
        return $this;
    }
    /**
     * Get advisorAdressLat value
     * @return float|null
     */
    public function getAdvisorAdressLat()
    {
        return $this->advisorAdressLat;
    }
    /**
     * Set advisorAdressLat value
     * @param float $advisorAdressLat
     * @return \StructType\Advisor
     */
    public function setAdvisorAdressLat($advisorAdressLat = null)
    {
        // validation for constraint: float
        if (!is_null($advisorAdressLat) && !(is_float($advisorAdressLat) || is_numeric($advisorAdressLat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($advisorAdressLat, true), gettype($advisorAdressLat)), __LINE__);
        }
        $this->advisorAdressLat = $advisorAdressLat;
        return $this;
    }
    /**
     * Get advisorAdressLng value
     * @return float|null
     */
    public function getAdvisorAdressLng()
    {
        return $this->advisorAdressLng;
    }
    /**
     * Set advisorAdressLng value
     * @param float $advisorAdressLng
     * @return \StructType\Advisor
     */
    public function setAdvisorAdressLng($advisorAdressLng = null)
    {
        // validation for constraint: float
        if (!is_null($advisorAdressLng) && !(is_float($advisorAdressLng) || is_numeric($advisorAdressLng))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($advisorAdressLng, true), gettype($advisorAdressLng)), __LINE__);
        }
        $this->advisorAdressLng = $advisorAdressLng;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Advisor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
