<?php

namespace EnumType;

/**
 * This class stands for zahlungsweiseType EnumType
 * @subpackage Enumerations
 */
class ZahlungsweiseType
{
    /**
     * Constant for value 'jährlich'
     * @return string 'jährlich'
     */
    const ENUM_VALUE_0 = 'jährlich';
    /**
     * Constant for value 'halbjährlich'
     * @return string 'halbjährlich'
     */
    const ENUM_VALUE_1 = 'halbjährlich';
    /**
     * Constant for value 'vierteljährlich'
     * @return string 'vierteljährlich'
     */
    const ENUM_VALUE_2 = 'vierteljährlich';
    /**
     * Constant for value 'monatlich'
     * @return string 'monatlich'
     */
    const ENUM_VALUE_3 = 'monatlich';
    /**
     * Constant for value 'einmalig'
     * @return string 'einmalig'
     */
    const ENUM_VALUE_4 = 'einmalig';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
