<?php

namespace EnumType;

/**
 * This class stands for wechselkennzeichenArt EnumType
 * @subpackage Enumerations
 */
class WechselkennzeichenArt
{
    /**
     * Constant for value 'Neues Fahrzeug als WKZ in bestehenden Vertrag einbündeln'
     * @return string 'Neues Fahrzeug als WKZ in bestehenden Vertrag einbündeln'
     */
    const ENUM_VALUE_0 = 'Neues Fahrzeug als WKZ in bestehenden Vertrag einbündeln';
    /**
     * Constant for value 'Fahrzeugwechsel im bestehenden WKZ-Vertrag'
     * @return string 'Fahrzeugwechsel im bestehenden WKZ-Vertrag'
     */
    const ENUM_VALUE_1 = 'Fahrzeugwechsel im bestehenden WKZ-Vertrag';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
