<?php

namespace EnumType;

/**
 * This class stands for tarifvarianteType EnumType
 * @subpackage Enumerations
 */
class TarifvarianteType
{
    /**
     * Constant for value 'ohne Leihwagen'
     * @return string 'ohne Leihwagen'
     */
    const ENUM_VALUE_0 = 'ohne Leihwagen';
    /**
     * Constant for value 'mit Leihwagen'
     * @return string 'mit Leihwagen'
     */
    const ENUM_VALUE_1 = 'mit Leihwagen';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
