<?php

namespace EnumType;

/**
 * This class stands for pauschalsummeType EnumType
 * @subpackage Enumerations
 */
class PauschalsummeType
{
    /**
     * Constant for value '7,6 Mio'
     * @return string '7,6 Mio'
     */
    const ENUM_VALUE_0 = '7,6 Mio';
    /**
     * Constant for value '10 Mio'
     * @return string '10 Mio'
     */
    const ENUM_VALUE_1 = '10 Mio';
    /**
     * Constant for value '15 Mio'
     * @return string '15 Mio'
     */
    const ENUM_VALUE_2 = '15 Mio';
    /**
     * Constant for value '20 Mio'
     * @return string '20 Mio'
     */
    const ENUM_VALUE_3 = '20 Mio';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
