<?php

namespace EnumType;

/**
 * This class stands for nutzungType EnumType
 * @subpackage Enumerations
 */
class NutzungType
{
    /**
     * Constant for value 'Privat'
     * @return string 'Privat'
     */
    const ENUM_VALUE_0 = 'Privat';
    /**
     * Constant for value 'Privat u. Beruf'
     * @return string 'Privat u. Beruf'
     */
    const ENUM_VALUE_1 = 'Privat u. Beruf';
    /**
     * Constant for value 'Beruf'
     * @return string 'Beruf'
     */
    const ENUM_VALUE_2 = 'Beruf';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
