<?php

namespace EnumType;

/**
 * This class stands for iuVersicherungsartType EnumType
 * @subpackage Enumerations
 */
class IuVersicherungsartType
{
    /**
     * Constant for value 'Kfz-Insassenschutz'
     * @return string 'Kfz-Insassenschutz'
     */
    const ENUM_VALUE_0 = 'Kfz-Insassenschutz';
    /**
     * Constant for value 'Kfz-Top-Insassenschutz'
     * @return string 'Kfz-Top-Insassenschutz'
     */
    const ENUM_VALUE_1 = 'Kfz-Top-Insassenschutz';
    /**
     * Constant for value 'Platzsystem'
     * @return string 'Platzsystem'
     */
    const ENUM_VALUE_2 = 'Platzsystem';
    /**
     * Constant for value 'Pauschalsystem'
     * @return string 'Pauschalsystem'
     */
    const ENUM_VALUE_3 = 'Pauschalsystem';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
