<?php

namespace EnumType;

/**
 * This class stands for befreiungsgrundType EnumType
 * @subpackage Enumerations
 */
class BefreiungsgrundType
{
    /**
     * Constant for value 'kein Befreiungsgrund'
     * @return string 'kein Befreiungsgrund'
     */
    const ENUM_VALUE_0 = 'kein Befreiungsgrund';
    /**
     * Constant for value 'KFZ des Bundes od. Gebietskörperschaften zur Verwendung im
     * öffentl. Sicherheitsdienst'
     * @return string 'KFZ des Bundes od. Gebietskörperschaften zur Verwendung im öffentl. Sicherheitsdienst'
     */
    const ENUM_VALUE_1 = 'KFZ des Bundes od. Gebietskörperschaften zur Verwendung im öffentl. Sicherheitsdienst';
    /**
     * Constant for value 'KFZ unterliegt nicht der Steuerpflicht'
     * @return string 'KFZ unterliegt nicht der Steuerpflicht'
     */
    const ENUM_VALUE_2 = 'KFZ unterliegt nicht der Steuerpflicht';
    /**
     * Constant for value 'KFZ zur Verw. für Körperbehinderte'
     * @return string 'KFZ zur Verw. für Körperbehinderte'
     */
    const ENUM_VALUE_3 = 'KFZ zur Verw. für Körperbehinderte';
    /**
     * Constant for value 'Hoteltaxi'
     * @return string 'Hoteltaxi'
     */
    const ENUM_VALUE_4 = 'Hoteltaxi';
    /**
     * Constant for value 'Diplomat (ohne VSSt Befreiung)'
     * @return string 'Diplomat (ohne VSSt Befreiung)'
     */
    const ENUM_VALUE_5 = 'Diplomat (ohne VSSt Befreiung)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @uses self::ENUM_VALUE_5
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
            self::ENUM_VALUE_5,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
