<?php

namespace EnumType;

/**
 * This class stands for aufloesungsgrund EnumType
 * @subpackage Enumerations
 */
class Aufloesungsgrund
{
    /**
     * Constant for value 'aus Schaden'
     * @return string 'aus Schaden'
     */
    const ENUM_VALUE_0 = 'aus Schaden';
    /**
     * Constant for value 'durch einvernehmliche Kündigung'
     * @return string 'durch einvernehmliche Kündigung'
     */
    const ENUM_VALUE_1 = 'durch einvernehmliche Kündigung';
    /**
     * Constant for value 'durch Ablauf'
     * @return string 'durch Ablauf'
     */
    const ENUM_VALUE_2 = 'durch Ablauf';
    /**
     * Constant for value 'durch Besitzwechsel'
     * @return string 'durch Besitzwechsel'
     */
    const ENUM_VALUE_3 = 'durch Besitzwechsel';
    /**
     * Constant for value 'aus sonstigen Gründen'
     * @return string 'aus sonstigen Gründen'
     */
    const ENUM_VALUE_4 = 'aus sonstigen Gründen';
    /**
     * Constant for value 'zum Ablauf gekündigte Vorversicherung'
     * @return string 'zum Ablauf gekündigte Vorversicherung'
     */
    const ENUM_VALUE_5 = 'zum Ablauf gekündigte Vorversicherung';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @uses self::ENUM_VALUE_5
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
            self::ENUM_VALUE_5,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
