<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for zulassungsdatenType StructType
 * @subpackage Structs
 */
class ZulassungsdatenType extends AbstractStructBase
{
    /**
     * The vbNummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $vbNummer;
    /**
     * The kfzKennzeichen
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $kfzKennzeichen;
    /**
     * The fahrgestellnummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $fahrgestellnummer;
    /**
     * Constructor method for zulassungsdatenType
     * @uses ZulassungsdatenType::setVbNummer()
     * @uses ZulassungsdatenType::setKfzKennzeichen()
     * @uses ZulassungsdatenType::setFahrgestellnummer()
     * @param string $vbNummer
     * @param string $kfzKennzeichen
     * @param string $fahrgestellnummer
     */
    public function __construct($vbNummer = null, $kfzKennzeichen = null, $fahrgestellnummer = null)
    {
        $this
            ->setVbNummer($vbNummer)
            ->setKfzKennzeichen($kfzKennzeichen)
            ->setFahrgestellnummer($fahrgestellnummer);
    }
    /**
     * Get vbNummer value
     * @return string|null
     */
    public function getVbNummer()
    {
        return $this->vbNummer;
    }
    /**
     * Set vbNummer value
     * @param string $vbNummer
     * @return \StructType\ZulassungsdatenType
     */
    public function setVbNummer($vbNummer = null)
    {
        // validation for constraint: string
        if (!is_null($vbNummer) && !is_string($vbNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vbNummer, true), gettype($vbNummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($vbNummer) && mb_strlen($vbNummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($vbNummer)), __LINE__);
        }
        $this->vbNummer = $vbNummer;
        return $this;
    }
    /**
     * Get kfzKennzeichen value
     * @return string|null
     */
    public function getKfzKennzeichen()
    {
        return $this->kfzKennzeichen;
    }
    /**
     * Set kfzKennzeichen value
     * @param string $kfzKennzeichen
     * @return \StructType\ZulassungsdatenType
     */
    public function setKfzKennzeichen($kfzKennzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($kfzKennzeichen) && !is_string($kfzKennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kfzKennzeichen, true), gettype($kfzKennzeichen)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($kfzKennzeichen) && mb_strlen($kfzKennzeichen) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($kfzKennzeichen)), __LINE__);
        }
        $this->kfzKennzeichen = $kfzKennzeichen;
        return $this;
    }
    /**
     * Get fahrgestellnummer value
     * @return string|null
     */
    public function getFahrgestellnummer()
    {
        return $this->fahrgestellnummer;
    }
    /**
     * Set fahrgestellnummer value
     * @param string $fahrgestellnummer
     * @return \StructType\ZulassungsdatenType
     */
    public function setFahrgestellnummer($fahrgestellnummer = null)
    {
        // validation for constraint: string
        if (!is_null($fahrgestellnummer) && !is_string($fahrgestellnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fahrgestellnummer, true), gettype($fahrgestellnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fahrgestellnummer) && mb_strlen($fahrgestellnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($fahrgestellnummer)), __LINE__);
        }
        $this->fahrgestellnummer = $fahrgestellnummer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZulassungsdatenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
