<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for zahlungsdatenType StructType
 * @subpackage Structs
 */
class ZahlungsdatenType extends AbstractStructBase
{
    /**
     * The zahlungsart
     * @var string
     */
    public $zahlungsart;
    /**
     * The kontonummer
     * Meta information extracted from the WSDL
     * - documentation: Abhängig von der Zahlungsart soll im Feld 'kontonummer' die Kundenkontonummer oder der IBAN befüllt werden.
     * - base: xs:string
     * - maxLength: 34
     * - minOccurs: 0
     * @var string
     */
    public $kontonummer;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $beschreibung;
    /**
     * Constructor method for zahlungsdatenType
     * @uses ZahlungsdatenType::setZahlungsart()
     * @uses ZahlungsdatenType::setKontonummer()
     * @uses ZahlungsdatenType::setBeschreibung()
     * @param string $zahlungsart
     * @param string $kontonummer
     * @param string $beschreibung
     */
    public function __construct($zahlungsart = null, $kontonummer = null, $beschreibung = null)
    {
        $this
            ->setZahlungsart($zahlungsart)
            ->setKontonummer($kontonummer)
            ->setBeschreibung($beschreibung);
    }
    /**
     * Get zahlungsart value
     * @return string|null
     */
    public function getZahlungsart()
    {
        return $this->zahlungsart;
    }
    /**
     * Set zahlungsart value
     * @uses \EnumType\ZahlungsartType::valueIsValid()
     * @uses \EnumType\ZahlungsartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlungsart
     * @return \StructType\ZahlungsdatenType
     */
    public function setZahlungsart($zahlungsart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ZahlungsartType::valueIsValid($zahlungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ZahlungsartType', is_array($zahlungsart) ? implode(', ', $zahlungsart) : var_export($zahlungsart, true), implode(', ', \EnumType\ZahlungsartType::getValidValues())), __LINE__);
        }
        $this->zahlungsart = $zahlungsart;
        return $this;
    }
    /**
     * Get kontonummer value
     * @return string|null
     */
    public function getKontonummer()
    {
        return $this->kontonummer;
    }
    /**
     * Set kontonummer value
     * @param string $kontonummer
     * @return \StructType\ZahlungsdatenType
     */
    public function setKontonummer($kontonummer = null)
    {
        // validation for constraint: string
        if (!is_null($kontonummer) && !is_string($kontonummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kontonummer, true), gettype($kontonummer)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($kontonummer) && mb_strlen($kontonummer) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($kontonummer)), __LINE__);
        }
        $this->kontonummer = $kontonummer;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * Set beschreibung value
     * @param string $beschreibung
     * @return \StructType\ZahlungsdatenType
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($beschreibung)), __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZahlungsdatenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
