<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for wechselkennzeichenType StructType
 * @subpackage Structs
 */
class WechselkennzeichenType extends AbstractStructBase
{
    /**
     * The wechselkennzeichenArt
     * @var string
     */
    public $wechselkennzeichenArt;
    /**
     * The bestehenderWechselkennzeichenvertrag
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{3}[\-][0-9]{4}[\-][0-9]{4}
     * @var string
     */
    public $bestehenderWechselkennzeichenvertrag;
    /**
     * The ersetztWirdFahrgestellnummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ersetztWirdFahrgestellnummer;
    /**
     * Constructor method for wechselkennzeichenType
     * @uses WechselkennzeichenType::setWechselkennzeichenArt()
     * @uses WechselkennzeichenType::setBestehenderWechselkennzeichenvertrag()
     * @uses WechselkennzeichenType::setErsetztWirdFahrgestellnummer()
     * @param string $wechselkennzeichenArt
     * @param string $bestehenderWechselkennzeichenvertrag
     * @param string $ersetztWirdFahrgestellnummer
     */
    public function __construct($wechselkennzeichenArt = null, $bestehenderWechselkennzeichenvertrag = null, $ersetztWirdFahrgestellnummer = null)
    {
        $this
            ->setWechselkennzeichenArt($wechselkennzeichenArt)
            ->setBestehenderWechselkennzeichenvertrag($bestehenderWechselkennzeichenvertrag)
            ->setErsetztWirdFahrgestellnummer($ersetztWirdFahrgestellnummer);
    }
    /**
     * Get wechselkennzeichenArt value
     * @return string|null
     */
    public function getWechselkennzeichenArt()
    {
        return $this->wechselkennzeichenArt;
    }
    /**
     * Set wechselkennzeichenArt value
     * @uses \EnumType\WechselkennzeichenArt::valueIsValid()
     * @uses \EnumType\WechselkennzeichenArt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wechselkennzeichenArt
     * @return \StructType\WechselkennzeichenType
     */
    public function setWechselkennzeichenArt($wechselkennzeichenArt = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WechselkennzeichenArt::valueIsValid($wechselkennzeichenArt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WechselkennzeichenArt', is_array($wechselkennzeichenArt) ? implode(', ', $wechselkennzeichenArt) : var_export($wechselkennzeichenArt, true), implode(', ', \EnumType\WechselkennzeichenArt::getValidValues())), __LINE__);
        }
        $this->wechselkennzeichenArt = $wechselkennzeichenArt;
        return $this;
    }
    /**
     * Get bestehenderWechselkennzeichenvertrag value
     * @return string|null
     */
    public function getBestehenderWechselkennzeichenvertrag()
    {
        return $this->bestehenderWechselkennzeichenvertrag;
    }
    /**
     * Set bestehenderWechselkennzeichenvertrag value
     * @param string $bestehenderWechselkennzeichenvertrag
     * @return \StructType\WechselkennzeichenType
     */
    public function setBestehenderWechselkennzeichenvertrag($bestehenderWechselkennzeichenvertrag = null)
    {
        // validation for constraint: string
        if (!is_null($bestehenderWechselkennzeichenvertrag) && !is_string($bestehenderWechselkennzeichenvertrag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestehenderWechselkennzeichenvertrag, true), gettype($bestehenderWechselkennzeichenvertrag)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{3}[\-][0-9]{4}[\-][0-9]{4})
        if (!is_null($bestehenderWechselkennzeichenvertrag) && !preg_match('/[0-9]{3}[\\-][0-9]{4}[\\-][0-9]{4}/', $bestehenderWechselkennzeichenvertrag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{3}[\-][0-9]{4}[\-][0-9]{4}', var_export($bestehenderWechselkennzeichenvertrag, true)), __LINE__);
        }
        $this->bestehenderWechselkennzeichenvertrag = $bestehenderWechselkennzeichenvertrag;
        return $this;
    }
    /**
     * Get ersetztWirdFahrgestellnummer value
     * @return string|null
     */
    public function getErsetztWirdFahrgestellnummer()
    {
        return $this->ersetztWirdFahrgestellnummer;
    }
    /**
     * Set ersetztWirdFahrgestellnummer value
     * @param string $ersetztWirdFahrgestellnummer
     * @return \StructType\WechselkennzeichenType
     */
    public function setErsetztWirdFahrgestellnummer($ersetztWirdFahrgestellnummer = null)
    {
        // validation for constraint: string
        if (!is_null($ersetztWirdFahrgestellnummer) && !is_string($ersetztWirdFahrgestellnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ersetztWirdFahrgestellnummer, true), gettype($ersetztWirdFahrgestellnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ersetztWirdFahrgestellnummer) && mb_strlen($ersetztWirdFahrgestellnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($ersetztWirdFahrgestellnummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ersetztWirdFahrgestellnummer) && mb_strlen($ersetztWirdFahrgestellnummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ersetztWirdFahrgestellnummer)), __LINE__);
        }
        $this->ersetztWirdFahrgestellnummer = $ersetztWirdFahrgestellnummer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WechselkennzeichenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
