<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vorversicherungenDetailType StructType
 * @subpackage Structs
 */
class VorversicherungenDetailType extends AbstractStructBase
{
    /**
     * The wurdenVorversicherungenAufgeloest
     * Meta information extracted from the WSDL
     * - documentation: Wurden für die beantragte Versicherung Vorversicherungen aufgelöst, oder wurden frühere Versicherungen abgelehnt oder gekündigt?
     * @var string
     */
    public $wurdenVorversicherungenAufgeloest;
    /**
     * The aufloesungsgrund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aufloesungsgrund;
    /**
     * The versicherungsgesellschaft
     * Meta information extracted from the WSDL
     * - documentation: OMDS VERS_UNTERNEHMEN VUNr - https://www.vvo.at/vvo/vvo.nsf/sysPages/x751F64EEDB80A61BC1257C3D007EACA2/$file/Handbuch_OMDS_2_x_2012-09-10.pdf - Kapitel 5
     * - base: xs:string
     * - pattern: [0-9]{3}
     * @var string
     */
    public $versicherungsgesellschaft;
    /**
     * Constructor method for vorversicherungenDetailType
     * @uses VorversicherungenDetailType::setWurdenVorversicherungenAufgeloest()
     * @uses VorversicherungenDetailType::setAufloesungsgrund()
     * @uses VorversicherungenDetailType::setVersicherungsgesellschaft()
     * @param string $wurdenVorversicherungenAufgeloest
     * @param string $aufloesungsgrund
     * @param string $versicherungsgesellschaft
     */
    public function __construct($wurdenVorversicherungenAufgeloest = null, $aufloesungsgrund = null, $versicherungsgesellschaft = null)
    {
        $this
            ->setWurdenVorversicherungenAufgeloest($wurdenVorversicherungenAufgeloest)
            ->setAufloesungsgrund($aufloesungsgrund)
            ->setVersicherungsgesellschaft($versicherungsgesellschaft);
    }
    /**
     * Get wurdenVorversicherungenAufgeloest value
     * @return string|null
     */
    public function getWurdenVorversicherungenAufgeloest()
    {
        return $this->wurdenVorversicherungenAufgeloest;
    }
    /**
     * Set wurdenVorversicherungenAufgeloest value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wurdenVorversicherungenAufgeloest
     * @return \StructType\VorversicherungenDetailType
     */
    public function setWurdenVorversicherungenAufgeloest($wurdenVorversicherungenAufgeloest = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($wurdenVorversicherungenAufgeloest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($wurdenVorversicherungenAufgeloest) ? implode(', ', $wurdenVorversicherungenAufgeloest) : var_export($wurdenVorversicherungenAufgeloest, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->wurdenVorversicherungenAufgeloest = $wurdenVorversicherungenAufgeloest;
        return $this;
    }
    /**
     * Get aufloesungsgrund value
     * @return string|null
     */
    public function getAufloesungsgrund()
    {
        return $this->aufloesungsgrund;
    }
    /**
     * Set aufloesungsgrund value
     * @uses \EnumType\Aufloesungsgrund::valueIsValid()
     * @uses \EnumType\Aufloesungsgrund::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aufloesungsgrund
     * @return \StructType\VorversicherungenDetailType
     */
    public function setAufloesungsgrund($aufloesungsgrund = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Aufloesungsgrund::valueIsValid($aufloesungsgrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Aufloesungsgrund', is_array($aufloesungsgrund) ? implode(', ', $aufloesungsgrund) : var_export($aufloesungsgrund, true), implode(', ', \EnumType\Aufloesungsgrund::getValidValues())), __LINE__);
        }
        $this->aufloesungsgrund = $aufloesungsgrund;
        return $this;
    }
    /**
     * Get versicherungsgesellschaft value
     * @return string|null
     */
    public function getVersicherungsgesellschaft()
    {
        return $this->versicherungsgesellschaft;
    }
    /**
     * Set versicherungsgesellschaft value
     * @param string $versicherungsgesellschaft
     * @return \StructType\VorversicherungenDetailType
     */
    public function setVersicherungsgesellschaft($versicherungsgesellschaft = null)
    {
        // validation for constraint: string
        if (!is_null($versicherungsgesellschaft) && !is_string($versicherungsgesellschaft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versicherungsgesellschaft, true), gettype($versicherungsgesellschaft)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{3})
        if (!is_null($versicherungsgesellschaft) && !preg_match('/[0-9]{3}/', $versicherungsgesellschaft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{3}', var_export($versicherungsgesellschaft, true)), __LINE__);
        }
        $this->versicherungsgesellschaft = $versicherungsgesellschaft;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VorversicherungenDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
