<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vinkulierungsdaten StructType
 * Meta information extracted from the WSDL
 * - documentation: Vinkulierungsdaten
 * @subpackage Structs
 */
class Vinkulierungsdaten extends AbstractStructBase
{
    /**
     * The code
     * @var int
     */
    public $code;
    /**
     * The bank
     * @var string
     */
    public $bank;
    /**
     * The gebBefreitKfz
     * @var bool
     */
    public $gebBefreitKfz;
    /**
     * The gebBefreitSach
     * @var bool
     */
    public $gebBefreitSach;
    /**
     * The strasse
     * @var string
     */
    public $strasse;
    /**
     * The plz
     * @var string
     */
    public $plz;
    /**
     * The hausnr
     * @var string
     */
    public $hausnr;
    /**
     * The ort
     * @var string
     */
    public $ort;
    /**
     * The postfach
     * @var string
     */
    public $postfach;
    /**
     * Constructor method for Vinkulierungsdaten
     * @uses Vinkulierungsdaten::setCode()
     * @uses Vinkulierungsdaten::setBank()
     * @uses Vinkulierungsdaten::setGebBefreitKfz()
     * @uses Vinkulierungsdaten::setGebBefreitSach()
     * @uses Vinkulierungsdaten::setStrasse()
     * @uses Vinkulierungsdaten::setPlz()
     * @uses Vinkulierungsdaten::setHausnr()
     * @uses Vinkulierungsdaten::setOrt()
     * @uses Vinkulierungsdaten::setPostfach()
     * @param int $code
     * @param string $bank
     * @param bool $gebBefreitKfz
     * @param bool $gebBefreitSach
     * @param string $strasse
     * @param string $plz
     * @param string $hausnr
     * @param string $ort
     * @param string $postfach
     */
    public function __construct($code = null, $bank = null, $gebBefreitKfz = null, $gebBefreitSach = null, $strasse = null, $plz = null, $hausnr = null, $ort = null, $postfach = null)
    {
        $this
            ->setCode($code)
            ->setBank($bank)
            ->setGebBefreitKfz($gebBefreitKfz)
            ->setGebBefreitSach($gebBefreitSach)
            ->setStrasse($strasse)
            ->setPlz($plz)
            ->setHausnr($hausnr)
            ->setOrt($ort)
            ->setPostfach($postfach);
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\Vinkulierungsdaten
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get bank value
     * @return string|null
     */
    public function getBank()
    {
        return $this->bank;
    }
    /**
     * Set bank value
     * @param string $bank
     * @return \StructType\Vinkulierungsdaten
     */
    public function setBank($bank = null)
    {
        // validation for constraint: string
        if (!is_null($bank) && !is_string($bank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank, true), gettype($bank)), __LINE__);
        }
        $this->bank = $bank;
        return $this;
    }
    /**
     * Get gebBefreitKfz value
     * @return bool|null
     */
    public function getGebBefreitKfz()
    {
        return $this->gebBefreitKfz;
    }
    /**
     * Set gebBefreitKfz value
     * @param bool $gebBefreitKfz
     * @return \StructType\Vinkulierungsdaten
     */
    public function setGebBefreitKfz($gebBefreitKfz = null)
    {
        // validation for constraint: boolean
        if (!is_null($gebBefreitKfz) && !is_bool($gebBefreitKfz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gebBefreitKfz, true), gettype($gebBefreitKfz)), __LINE__);
        }
        $this->gebBefreitKfz = $gebBefreitKfz;
        return $this;
    }
    /**
     * Get gebBefreitSach value
     * @return bool|null
     */
    public function getGebBefreitSach()
    {
        return $this->gebBefreitSach;
    }
    /**
     * Set gebBefreitSach value
     * @param bool $gebBefreitSach
     * @return \StructType\Vinkulierungsdaten
     */
    public function setGebBefreitSach($gebBefreitSach = null)
    {
        // validation for constraint: boolean
        if (!is_null($gebBefreitSach) && !is_bool($gebBefreitSach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gebBefreitSach, true), gettype($gebBefreitSach)), __LINE__);
        }
        $this->gebBefreitSach = $gebBefreitSach;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\Vinkulierungsdaten
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\Vinkulierungsdaten
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get hausnr value
     * @return string|null
     */
    public function getHausnr()
    {
        return $this->hausnr;
    }
    /**
     * Set hausnr value
     * @param string $hausnr
     * @return \StructType\Vinkulierungsdaten
     */
    public function setHausnr($hausnr = null)
    {
        // validation for constraint: string
        if (!is_null($hausnr) && !is_string($hausnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnr, true), gettype($hausnr)), __LINE__);
        }
        $this->hausnr = $hausnr;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\Vinkulierungsdaten
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get postfach value
     * @return string|null
     */
    public function getPostfach()
    {
        return $this->postfach;
    }
    /**
     * Set postfach value
     * @param string $postfach
     * @return \StructType\Vinkulierungsdaten
     */
    public function setPostfach($postfach = null)
    {
        // validation for constraint: string
        if (!is_null($postfach) && !is_string($postfach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postfach, true), gettype($postfach)), __LINE__);
        }
        $this->postfach = $postfach;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vinkulierungsdaten
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
