<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for versichertesFahrzeugType StructType
 * @subpackage Structs
 */
class VersichertesFahrzeugType extends AbstractStructBase
{
    /**
     * The kfzArt
     * @var string
     */
    public $kfzArt;
    /**
     * The kfzVerwendung
     * @var string
     */
    public $kfzVerwendung;
    /**
     * The taxiMietwagen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxiMietwagen;
    /**
     * The geschaeftlichBefoerdertesGut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $geschaeftlichBefoerdertesGut;
    /**
     * The nutzlast
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $nutzlast;
    /**
     * Constructor method for versichertesFahrzeugType
     * @uses VersichertesFahrzeugType::setKfzArt()
     * @uses VersichertesFahrzeugType::setKfzVerwendung()
     * @uses VersichertesFahrzeugType::setTaxiMietwagen()
     * @uses VersichertesFahrzeugType::setGeschaeftlichBefoerdertesGut()
     * @uses VersichertesFahrzeugType::setNutzlast()
     * @param string $kfzArt
     * @param string $kfzVerwendung
     * @param string $taxiMietwagen
     * @param string $geschaeftlichBefoerdertesGut
     * @param int $nutzlast
     */
    public function __construct($kfzArt = null, $kfzVerwendung = null, $taxiMietwagen = null, $geschaeftlichBefoerdertesGut = null, $nutzlast = null)
    {
        $this
            ->setKfzArt($kfzArt)
            ->setKfzVerwendung($kfzVerwendung)
            ->setTaxiMietwagen($taxiMietwagen)
            ->setGeschaeftlichBefoerdertesGut($geschaeftlichBefoerdertesGut)
            ->setNutzlast($nutzlast);
    }
    /**
     * Get kfzArt value
     * @return string|null
     */
    public function getKfzArt()
    {
        return $this->kfzArt;
    }
    /**
     * Set kfzArt value
     * @uses \EnumType\KfzArtType::valueIsValid()
     * @uses \EnumType\KfzArtType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kfzArt
     * @return \StructType\VersichertesFahrzeugType
     */
    public function setKfzArt($kfzArt = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KfzArtType::valueIsValid($kfzArt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KfzArtType', is_array($kfzArt) ? implode(', ', $kfzArt) : var_export($kfzArt, true), implode(', ', \EnumType\KfzArtType::getValidValues())), __LINE__);
        }
        $this->kfzArt = $kfzArt;
        return $this;
    }
    /**
     * Get kfzVerwendung value
     * @return string|null
     */
    public function getKfzVerwendung()
    {
        return $this->kfzVerwendung;
    }
    /**
     * Set kfzVerwendung value
     * @uses \EnumType\KfzVerwendungType::valueIsValid()
     * @uses \EnumType\KfzVerwendungType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kfzVerwendung
     * @return \StructType\VersichertesFahrzeugType
     */
    public function setKfzVerwendung($kfzVerwendung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KfzVerwendungType::valueIsValid($kfzVerwendung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KfzVerwendungType', is_array($kfzVerwendung) ? implode(', ', $kfzVerwendung) : var_export($kfzVerwendung, true), implode(', ', \EnumType\KfzVerwendungType::getValidValues())), __LINE__);
        }
        $this->kfzVerwendung = $kfzVerwendung;
        return $this;
    }
    /**
     * Get taxiMietwagen value
     * @return string|null
     */
    public function getTaxiMietwagen()
    {
        return $this->taxiMietwagen;
    }
    /**
     * Set taxiMietwagen value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxiMietwagen
     * @return \StructType\VersichertesFahrzeugType
     */
    public function setTaxiMietwagen($taxiMietwagen = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($taxiMietwagen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($taxiMietwagen) ? implode(', ', $taxiMietwagen) : var_export($taxiMietwagen, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->taxiMietwagen = $taxiMietwagen;
        return $this;
    }
    /**
     * Get geschaeftlichBefoerdertesGut value
     * @return string|null
     */
    public function getGeschaeftlichBefoerdertesGut()
    {
        return $this->geschaeftlichBefoerdertesGut;
    }
    /**
     * Set geschaeftlichBefoerdertesGut value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geschaeftlichBefoerdertesGut
     * @return \StructType\VersichertesFahrzeugType
     */
    public function setGeschaeftlichBefoerdertesGut($geschaeftlichBefoerdertesGut = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($geschaeftlichBefoerdertesGut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($geschaeftlichBefoerdertesGut) ? implode(', ', $geschaeftlichBefoerdertesGut) : var_export($geschaeftlichBefoerdertesGut, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->geschaeftlichBefoerdertesGut = $geschaeftlichBefoerdertesGut;
        return $this;
    }
    /**
     * Get nutzlast value
     * @return int|null
     */
    public function getNutzlast()
    {
        return $this->nutzlast;
    }
    /**
     * Set nutzlast value
     * @param int $nutzlast
     * @return \StructType\VersichertesFahrzeugType
     */
    public function setNutzlast($nutzlast = null)
    {
        // validation for constraint: int
        if (!is_null($nutzlast) && !(is_int($nutzlast) || ctype_digit($nutzlast))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nutzlast, true), gettype($nutzlast)), __LINE__);
        }
        $this->nutzlast = $nutzlast;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VersichertesFahrzeugType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
